/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorAsyncClient;
import software.amazon.awssdk.services.frauddetector.internal.UserAgentUtils;
import software.amazon.awssdk.services.frauddetector.model.GetEntityTypesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEntityTypesResponse;

public class GetEntityTypesPublisher
implements SdkPublisher<GetEntityTypesResponse> {
    private final FraudDetectorAsyncClient client;
    private final GetEntityTypesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetEntityTypesPublisher(FraudDetectorAsyncClient client, GetEntityTypesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetEntityTypesPublisher(FraudDetectorAsyncClient client, GetEntityTypesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetEntityTypesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetEntityTypesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetEntityTypesResponseFetcher
    implements AsyncPageFetcher<GetEntityTypesResponse> {
        private GetEntityTypesResponseFetcher() {
        }

        public boolean hasNextPage(GetEntityTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetEntityTypesResponse> nextPage(GetEntityTypesResponse previousPage) {
            if (previousPage == null) {
                return GetEntityTypesPublisher.this.client.getEntityTypes(GetEntityTypesPublisher.this.firstRequest);
            }
            return GetEntityTypesPublisher.this.client.getEntityTypes((GetEntityTypesRequest)((Object)GetEntityTypesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

