/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.internal.UserAgentUtils;
import software.amazon.awssdk.services.frauddetector.model.GetLabelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetLabelsResponse;

public class GetLabelsIterable
implements SdkIterable<GetLabelsResponse> {
    private final FraudDetectorClient client;
    private final GetLabelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetLabelsIterable(FraudDetectorClient client, GetLabelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetLabelsResponseFetcher();
    }

    public Iterator<GetLabelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetLabelsResponseFetcher
    implements SyncPageFetcher<GetLabelsResponse> {
        private GetLabelsResponseFetcher() {
        }

        public boolean hasNextPage(GetLabelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetLabelsResponse nextPage(GetLabelsResponse previousPage) {
            if (previousPage == null) {
                return GetLabelsIterable.this.client.getLabels(GetLabelsIterable.this.firstRequest);
            }
            return GetLabelsIterable.this.client.getLabels((GetLabelsRequest)((Object)GetLabelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

