/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorAsyncClient;
import software.amazon.awssdk.services.frauddetector.internal.UserAgentUtils;
import software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetOutcomesResponse;

public class GetOutcomesPublisher
implements SdkPublisher<GetOutcomesResponse> {
    private final FraudDetectorAsyncClient client;
    private final GetOutcomesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetOutcomesPublisher(FraudDetectorAsyncClient client, GetOutcomesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetOutcomesPublisher(FraudDetectorAsyncClient client, GetOutcomesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetOutcomesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetOutcomesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetOutcomesResponseFetcher
    implements AsyncPageFetcher<GetOutcomesResponse> {
        private GetOutcomesResponseFetcher() {
        }

        public boolean hasNextPage(GetOutcomesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetOutcomesResponse> nextPage(GetOutcomesResponse previousPage) {
            if (previousPage == null) {
                return GetOutcomesPublisher.this.client.getOutcomes(GetOutcomesPublisher.this.firstRequest);
            }
            return GetOutcomesPublisher.this.client.getOutcomes((GetOutcomesRequest)((Object)GetOutcomesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

