/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.DiskIopsConfigurationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiskIopsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DiskIopsConfiguration> {
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(DiskIopsConfiguration.getter(DiskIopsConfiguration::modeAsString)).setter(DiskIopsConfiguration.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<Long> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Iops").getter(DiskIopsConfiguration.getter(DiskIopsConfiguration::iops)).setter(DiskIopsConfiguration.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, IOPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String mode;
    private final Long iops;

    private DiskIopsConfiguration(BuilderImpl builder) {
        this.mode = builder.mode;
        this.iops = builder.iops;
    }

    public final DiskIopsConfigurationMode mode() {
        return DiskIopsConfigurationMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final Long iops() {
        return this.iops;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskIopsConfiguration)) {
            return false;
        }
        DiskIopsConfiguration other = (DiskIopsConfiguration)obj;
        return Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.iops(), other.iops());
    }

    public final String toString() {
        return ToString.builder((String)"DiskIopsConfiguration").add("Mode", (Object)this.modeAsString()).add("Iops", (Object)this.iops()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiskIopsConfiguration, T> g) {
        return obj -> g.apply((DiskIopsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mode;
        private Long iops;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskIopsConfiguration model) {
            this.mode(model.mode);
            this.iops(model.iops);
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(DiskIopsConfigurationMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Long getIops() {
            return this.iops;
        }

        public final void setIops(Long iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Long iops) {
            this.iops = iops;
            return this;
        }

        public DiskIopsConfiguration build() {
            return new DiskIopsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DiskIopsConfiguration> {
        public Builder mode(String var1);

        public Builder mode(DiskIopsConfigurationMode var1);

        public Builder iops(Long var1);
    }
}

