/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.globalaccelerator;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.globalaccelerator.DefaultGlobalAcceleratorBaseClientBuilder;
import software.amazon.awssdk.services.globalaccelerator.DefaultGlobalAcceleratorClient;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorClient;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorClientBuilder;
import software.amazon.awssdk.services.globalaccelerator.GlobalAcceleratorServiceClientConfiguration;
import software.amazon.awssdk.services.globalaccelerator.endpoints.GlobalAcceleratorEndpointProvider;

@SdkInternalApi
final class DefaultGlobalAcceleratorClientBuilder
extends DefaultGlobalAcceleratorBaseClientBuilder<GlobalAcceleratorClientBuilder, GlobalAcceleratorClient>
implements GlobalAcceleratorClientBuilder {
    DefaultGlobalAcceleratorClientBuilder() {
    }

    @Override
    public DefaultGlobalAcceleratorClientBuilder endpointProvider(GlobalAcceleratorEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GlobalAcceleratorClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultGlobalAcceleratorClientBuilder.validateClientOptions(clientConfiguration);
        GlobalAcceleratorServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultGlobalAcceleratorClient client = new DefaultGlobalAcceleratorClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private GlobalAcceleratorServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return GlobalAcceleratorServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

