/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.glue.DefaultGlueAsyncClient;
import software.amazon.awssdk.services.glue.DefaultGlueBaseClientBuilder;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.GlueAsyncClientBuilder;
import software.amazon.awssdk.services.glue.GlueServiceClientConfiguration;
import software.amazon.awssdk.services.glue.endpoints.GlueEndpointProvider;

@SdkInternalApi
final class DefaultGlueAsyncClientBuilder
extends DefaultGlueBaseClientBuilder<GlueAsyncClientBuilder, GlueAsyncClient>
implements GlueAsyncClientBuilder {
    DefaultGlueAsyncClientBuilder() {
    }

    @Override
    public DefaultGlueAsyncClientBuilder endpointProvider(GlueEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GlueAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultGlueAsyncClientBuilder.validateClientOptions(clientConfiguration);
        GlueServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultGlueAsyncClient client = new DefaultGlueAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private GlueServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return GlueServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

