/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CloudWatchEncryptionMode {
    DISABLED("DISABLED"),
    SSE_KMS("SSE-KMS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CloudWatchEncryptionMode> VALUE_MAP;
    private final String value;

    private CloudWatchEncryptionMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CloudWatchEncryptionMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CloudWatchEncryptionMode> knownValues() {
        EnumSet<CloudWatchEncryptionMode> knownValues = EnumSet.allOf(CloudWatchEncryptionMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CloudWatchEncryptionMode.class, CloudWatchEncryptionMode::toString);
    }
}

