/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LoggerComponent {
    GREENGRASS_SYSTEM("GreengrassSystem"),
    LAMBDA("Lambda"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LoggerComponent> VALUE_MAP;
    private final String value;

    private LoggerComponent(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LoggerComponent fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LoggerComponent> knownValues() {
        EnumSet<LoggerComponent> knownValues = EnumSet.allOf(LoggerComponent.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LoggerComponent.class, LoggerComponent::toString);
    }
}

