/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.greengrassv2.DefaultGreengrassV2AsyncClient;
import software.amazon.awssdk.services.greengrassv2.DefaultGreengrassV2BaseClientBuilder;
import software.amazon.awssdk.services.greengrassv2.GreengrassV2AsyncClient;
import software.amazon.awssdk.services.greengrassv2.GreengrassV2AsyncClientBuilder;
import software.amazon.awssdk.services.greengrassv2.GreengrassV2ServiceClientConfiguration;
import software.amazon.awssdk.services.greengrassv2.endpoints.GreengrassV2EndpointProvider;

@SdkInternalApi
final class DefaultGreengrassV2AsyncClientBuilder
extends DefaultGreengrassV2BaseClientBuilder<GreengrassV2AsyncClientBuilder, GreengrassV2AsyncClient>
implements GreengrassV2AsyncClientBuilder {
    DefaultGreengrassV2AsyncClientBuilder() {
    }

    @Override
    public DefaultGreengrassV2AsyncClientBuilder endpointProvider(GreengrassV2EndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GreengrassV2AsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultGreengrassV2AsyncClientBuilder.validateClientOptions(clientConfiguration);
        GreengrassV2ServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultGreengrassV2AsyncClient client = new DefaultGreengrassV2AsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private GreengrassV2ServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return GreengrassV2ServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

