/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.greengrassv2.GreengrassV2AsyncClient;
import software.amazon.awssdk.services.greengrassv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.greengrassv2.model.EffectiveDeployment;
import software.amazon.awssdk.services.greengrassv2.model.ListEffectiveDeploymentsRequest;
import software.amazon.awssdk.services.greengrassv2.model.ListEffectiveDeploymentsResponse;

public class ListEffectiveDeploymentsPublisher
implements SdkPublisher<ListEffectiveDeploymentsResponse> {
    private final GreengrassV2AsyncClient client;
    private final ListEffectiveDeploymentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEffectiveDeploymentsPublisher(GreengrassV2AsyncClient client, ListEffectiveDeploymentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEffectiveDeploymentsPublisher(GreengrassV2AsyncClient client, ListEffectiveDeploymentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEffectiveDeploymentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEffectiveDeploymentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EffectiveDeployment> effectiveDeployments() {
        Function<ListEffectiveDeploymentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.effectiveDeployments() != null) {
                return response.effectiveDeployments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEffectiveDeploymentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEffectiveDeploymentsResponseFetcher
    implements AsyncPageFetcher<ListEffectiveDeploymentsResponse> {
        private ListEffectiveDeploymentsResponseFetcher() {
        }

        public boolean hasNextPage(ListEffectiveDeploymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEffectiveDeploymentsResponse> nextPage(ListEffectiveDeploymentsResponse previousPage) {
            if (previousPage == null) {
                return ListEffectiveDeploymentsPublisher.this.client.listEffectiveDeployments(ListEffectiveDeploymentsPublisher.this.firstRequest);
            }
            return ListEffectiveDeploymentsPublisher.this.client.listEffectiveDeployments((ListEffectiveDeploymentsRequest)((Object)ListEffectiveDeploymentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

