/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DetectorStatus {
    ENABLED("ENABLED"),
    DISABLED("DISABLED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DetectorStatus> VALUE_MAP;
    private final String value;

    private DetectorStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DetectorStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DetectorStatus> knownValues() {
        EnumSet<DetectorStatus> knownValues = EnumSet.allOf(DetectorStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DetectorStatus.class, DetectorStatus::toString);
    }
}

