/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.RemoteIpDetails;
import software.amazon.awssdk.services.guardduty.model.SourceIpsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KubernetesApiCallAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KubernetesApiCallAction> {
    private static final SdkField<String> REQUEST_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestUri").getter(KubernetesApiCallAction.getter(KubernetesApiCallAction::requestUri)).setter(KubernetesApiCallAction.setter(Builder::requestUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestUri").build()}).build();
    private static final SdkField<String> VERB_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Verb").getter(KubernetesApiCallAction.getter(KubernetesApiCallAction::verb)).setter(KubernetesApiCallAction.setter(Builder::verb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("verb").build()}).build();
    private static final SdkField<List<String>> SOURCE_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceIps").getter(KubernetesApiCallAction.getter(KubernetesApiCallAction::sourceIps)).setter(KubernetesApiCallAction.setter(Builder::sourceIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_AGENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserAgent").getter(KubernetesApiCallAction.getter(KubernetesApiCallAction::userAgent)).setter(KubernetesApiCallAction.setter(Builder::userAgent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAgent").build()}).build();
    private static final SdkField<RemoteIpDetails> REMOTE_IP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemoteIpDetails").getter(KubernetesApiCallAction.getter(KubernetesApiCallAction::remoteIpDetails)).setter(KubernetesApiCallAction.setter(Builder::remoteIpDetails)).constructor(RemoteIpDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteIpDetails").build()}).build();
    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StatusCode").getter(KubernetesApiCallAction.getter(KubernetesApiCallAction::statusCode)).setter(KubernetesApiCallAction.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final SdkField<String> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Parameters").getter(KubernetesApiCallAction.getter(KubernetesApiCallAction::parameters)).setter(KubernetesApiCallAction.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_URI_FIELD, VERB_FIELD, SOURCE_IPS_FIELD, USER_AGENT_FIELD, REMOTE_IP_DETAILS_FIELD, STATUS_CODE_FIELD, PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String requestUri;
    private final String verb;
    private final List<String> sourceIps;
    private final String userAgent;
    private final RemoteIpDetails remoteIpDetails;
    private final Integer statusCode;
    private final String parameters;

    private KubernetesApiCallAction(BuilderImpl builder) {
        this.requestUri = builder.requestUri;
        this.verb = builder.verb;
        this.sourceIps = builder.sourceIps;
        this.userAgent = builder.userAgent;
        this.remoteIpDetails = builder.remoteIpDetails;
        this.statusCode = builder.statusCode;
        this.parameters = builder.parameters;
    }

    public final String requestUri() {
        return this.requestUri;
    }

    public final String verb() {
        return this.verb;
    }

    public final boolean hasSourceIps() {
        return this.sourceIps != null && !(this.sourceIps instanceof SdkAutoConstructList);
    }

    public final List<String> sourceIps() {
        return this.sourceIps;
    }

    public final String userAgent() {
        return this.userAgent;
    }

    public final RemoteIpDetails remoteIpDetails() {
        return this.remoteIpDetails;
    }

    public final Integer statusCode() {
        return this.statusCode;
    }

    public final String parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.requestUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.verb());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceIps() ? this.sourceIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userAgent());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesApiCallAction)) {
            return false;
        }
        KubernetesApiCallAction other = (KubernetesApiCallAction)obj;
        return Objects.equals(this.requestUri(), other.requestUri()) && Objects.equals(this.verb(), other.verb()) && this.hasSourceIps() == other.hasSourceIps() && Objects.equals(this.sourceIps(), other.sourceIps()) && Objects.equals(this.userAgent(), other.userAgent()) && Objects.equals(this.remoteIpDetails(), other.remoteIpDetails()) && Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"KubernetesApiCallAction").add("RequestUri", (Object)this.requestUri()).add("Verb", (Object)this.verb()).add("SourceIps", this.hasSourceIps() ? this.sourceIps() : null).add("UserAgent", (Object)this.userAgent()).add("RemoteIpDetails", (Object)this.remoteIpDetails()).add("StatusCode", (Object)this.statusCode()).add("Parameters", (Object)this.parameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestUri": {
                return Optional.ofNullable(clazz.cast(this.requestUri()));
            }
            case "Verb": {
                return Optional.ofNullable(clazz.cast(this.verb()));
            }
            case "SourceIps": {
                return Optional.ofNullable(clazz.cast(this.sourceIps()));
            }
            case "UserAgent": {
                return Optional.ofNullable(clazz.cast(this.userAgent()));
            }
            case "RemoteIpDetails": {
                return Optional.ofNullable(clazz.cast(this.remoteIpDetails()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KubernetesApiCallAction, T> g) {
        return obj -> g.apply((KubernetesApiCallAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String requestUri;
        private String verb;
        private List<String> sourceIps = DefaultSdkAutoConstructList.getInstance();
        private String userAgent;
        private RemoteIpDetails remoteIpDetails;
        private Integer statusCode;
        private String parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesApiCallAction model) {
            this.requestUri(model.requestUri);
            this.verb(model.verb);
            this.sourceIps(model.sourceIps);
            this.userAgent(model.userAgent);
            this.remoteIpDetails(model.remoteIpDetails);
            this.statusCode(model.statusCode);
            this.parameters(model.parameters);
        }

        public final String getRequestUri() {
            return this.requestUri;
        }

        public final void setRequestUri(String requestUri) {
            this.requestUri = requestUri;
        }

        @Override
        public final Builder requestUri(String requestUri) {
            this.requestUri = requestUri;
            return this;
        }

        public final String getVerb() {
            return this.verb;
        }

        public final void setVerb(String verb) {
            this.verb = verb;
        }

        @Override
        public final Builder verb(String verb) {
            this.verb = verb;
            return this;
        }

        public final Collection<String> getSourceIps() {
            if (this.sourceIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceIps;
        }

        public final void setSourceIps(Collection<String> sourceIps) {
            this.sourceIps = SourceIpsCopier.copy(sourceIps);
        }

        @Override
        public final Builder sourceIps(Collection<String> sourceIps) {
            this.sourceIps = SourceIpsCopier.copy(sourceIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceIps(String ... sourceIps) {
            this.sourceIps(Arrays.asList(sourceIps));
            return this;
        }

        public final String getUserAgent() {
            return this.userAgent;
        }

        public final void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        @Override
        public final Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public final RemoteIpDetails.Builder getRemoteIpDetails() {
            return this.remoteIpDetails != null ? this.remoteIpDetails.toBuilder() : null;
        }

        public final void setRemoteIpDetails(RemoteIpDetails.BuilderImpl remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails != null ? remoteIpDetails.build() : null;
        }

        @Override
        public final Builder remoteIpDetails(RemoteIpDetails remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails;
            return this;
        }

        public final Integer getStatusCode() {
            return this.statusCode;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final String getParameters() {
            return this.parameters;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public KubernetesApiCallAction build() {
            return new KubernetesApiCallAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KubernetesApiCallAction> {
        public Builder requestUri(String var1);

        public Builder verb(String var1);

        public Builder sourceIps(Collection<String> var1);

        public Builder sourceIps(String ... var1);

        public Builder userAgent(String var1);

        public Builder remoteIpDetails(RemoteIpDetails var1);

        default public Builder remoteIpDetails(Consumer<RemoteIpDetails.Builder> remoteIpDetails) {
            return this.remoteIpDetails((RemoteIpDetails)((RemoteIpDetails.Builder)RemoteIpDetails.builder().applyMutation(remoteIpDetails)).build());
        }

        public Builder statusCode(Integer var1);

        public Builder parameters(String var1);
    }
}

