/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.ScanThreatName;
import software.amazon.awssdk.services.guardduty.model.ScanThreatNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThreatDetectedByName
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThreatDetectedByName> {
    private static final SdkField<Integer> ITEM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ItemCount").getter(ThreatDetectedByName.getter(ThreatDetectedByName::itemCount)).setter(ThreatDetectedByName.setter(Builder::itemCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemCount").build()}).build();
    private static final SdkField<Integer> UNIQUE_THREAT_NAME_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UniqueThreatNameCount").getter(ThreatDetectedByName.getter(ThreatDetectedByName::uniqueThreatNameCount)).setter(ThreatDetectedByName.setter(Builder::uniqueThreatNameCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uniqueThreatNameCount").build()}).build();
    private static final SdkField<Boolean> SHORTENED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Shortened").getter(ThreatDetectedByName.getter(ThreatDetectedByName::shortened)).setter(ThreatDetectedByName.setter(Builder::shortened)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shortened").build()}).build();
    private static final SdkField<List<ScanThreatName>> THREAT_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ThreatNames").getter(ThreatDetectedByName.getter(ThreatDetectedByName::threatNames)).setter(ThreatDetectedByName.setter(Builder::threatNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScanThreatName::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_COUNT_FIELD, UNIQUE_THREAT_NAME_COUNT_FIELD, SHORTENED_FIELD, THREAT_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer itemCount;
    private final Integer uniqueThreatNameCount;
    private final Boolean shortened;
    private final List<ScanThreatName> threatNames;

    private ThreatDetectedByName(BuilderImpl builder) {
        this.itemCount = builder.itemCount;
        this.uniqueThreatNameCount = builder.uniqueThreatNameCount;
        this.shortened = builder.shortened;
        this.threatNames = builder.threatNames;
    }

    public final Integer itemCount() {
        return this.itemCount;
    }

    public final Integer uniqueThreatNameCount() {
        return this.uniqueThreatNameCount;
    }

    public final Boolean shortened() {
        return this.shortened;
    }

    public final boolean hasThreatNames() {
        return this.threatNames != null && !(this.threatNames instanceof SdkAutoConstructList);
    }

    public final List<ScanThreatName> threatNames() {
        return this.threatNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.uniqueThreatNameCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.shortened());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThreatNames() ? this.threatNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThreatDetectedByName)) {
            return false;
        }
        ThreatDetectedByName other = (ThreatDetectedByName)obj;
        return Objects.equals(this.itemCount(), other.itemCount()) && Objects.equals(this.uniqueThreatNameCount(), other.uniqueThreatNameCount()) && Objects.equals(this.shortened(), other.shortened()) && this.hasThreatNames() == other.hasThreatNames() && Objects.equals(this.threatNames(), other.threatNames());
    }

    public final String toString() {
        return ToString.builder((String)"ThreatDetectedByName").add("ItemCount", (Object)this.itemCount()).add("UniqueThreatNameCount", (Object)this.uniqueThreatNameCount()).add("Shortened", (Object)this.shortened()).add("ThreatNames", this.hasThreatNames() ? this.threatNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ItemCount": {
                return Optional.ofNullable(clazz.cast(this.itemCount()));
            }
            case "UniqueThreatNameCount": {
                return Optional.ofNullable(clazz.cast(this.uniqueThreatNameCount()));
            }
            case "Shortened": {
                return Optional.ofNullable(clazz.cast(this.shortened()));
            }
            case "ThreatNames": {
                return Optional.ofNullable(clazz.cast(this.threatNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThreatDetectedByName, T> g) {
        return obj -> g.apply((ThreatDetectedByName)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer itemCount;
        private Integer uniqueThreatNameCount;
        private Boolean shortened;
        private List<ScanThreatName> threatNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ThreatDetectedByName model) {
            this.itemCount(model.itemCount);
            this.uniqueThreatNameCount(model.uniqueThreatNameCount);
            this.shortened(model.shortened);
            this.threatNames(model.threatNames);
        }

        public final Integer getItemCount() {
            return this.itemCount;
        }

        public final void setItemCount(Integer itemCount) {
            this.itemCount = itemCount;
        }

        @Override
        public final Builder itemCount(Integer itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final Integer getUniqueThreatNameCount() {
            return this.uniqueThreatNameCount;
        }

        public final void setUniqueThreatNameCount(Integer uniqueThreatNameCount) {
            this.uniqueThreatNameCount = uniqueThreatNameCount;
        }

        @Override
        public final Builder uniqueThreatNameCount(Integer uniqueThreatNameCount) {
            this.uniqueThreatNameCount = uniqueThreatNameCount;
            return this;
        }

        public final Boolean getShortened() {
            return this.shortened;
        }

        public final void setShortened(Boolean shortened) {
            this.shortened = shortened;
        }

        @Override
        public final Builder shortened(Boolean shortened) {
            this.shortened = shortened;
            return this;
        }

        public final List<ScanThreatName.Builder> getThreatNames() {
            List<ScanThreatName.Builder> result = ScanThreatNamesCopier.copyToBuilder(this.threatNames);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreatNames(Collection<ScanThreatName.BuilderImpl> threatNames) {
            this.threatNames = ScanThreatNamesCopier.copyFromBuilder(threatNames);
        }

        @Override
        public final Builder threatNames(Collection<ScanThreatName> threatNames) {
            this.threatNames = ScanThreatNamesCopier.copy(threatNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatNames(ScanThreatName ... threatNames) {
            this.threatNames(Arrays.asList(threatNames));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatNames(Consumer<ScanThreatName.Builder> ... threatNames) {
            this.threatNames(Stream.of(threatNames).map(c -> (ScanThreatName)((ScanThreatName.Builder)ScanThreatName.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ThreatDetectedByName build() {
            return new ThreatDetectedByName(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThreatDetectedByName> {
        public Builder itemCount(Integer var1);

        public Builder uniqueThreatNameCount(Integer var1);

        public Builder shortened(Boolean var1);

        public Builder threatNames(Collection<ScanThreatName> var1);

        public Builder threatNames(ScanThreatName ... var1);

        public Builder threatNames(Consumer<ScanThreatName.Builder> ... var1);
    }
}

