/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.ImageScanFinding;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingsResponse;

public class ListImageScanFindingsIterable
implements SdkIterable<ListImageScanFindingsResponse> {
    private final ImagebuilderClient client;
    private final ListImageScanFindingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImageScanFindingsIterable(ImagebuilderClient client, ListImageScanFindingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListImageScanFindingsResponseFetcher();
    }

    public Iterator<ListImageScanFindingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImageScanFinding> findings() {
        Function<ListImageScanFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.findings() != null) {
                return response.findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListImageScanFindingsResponseFetcher
    implements SyncPageFetcher<ListImageScanFindingsResponse> {
        private ListImageScanFindingsResponseFetcher() {
        }

        public boolean hasNextPage(ListImageScanFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImageScanFindingsResponse nextPage(ListImageScanFindingsResponse previousPage) {
            if (previousPage == null) {
                return ListImageScanFindingsIterable.this.client.listImageScanFindings(ListImageScanFindingsIterable.this.firstRequest);
            }
            return ListImageScanFindingsIterable.this.client.listImageScanFindings((ListImageScanFindingsRequest)((Object)ListImageScanFindingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

