/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.BillingGroupMetadata;
import software.amazon.awssdk.services.iot.model.BillingGroupProperties;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBillingGroupResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeBillingGroupResponse> {
    private static final SdkField<String> BILLING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("billingGroupName").getter(DescribeBillingGroupResponse.getter(DescribeBillingGroupResponse::billingGroupName)).setter(DescribeBillingGroupResponse.setter(Builder::billingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupName").build()}).build();
    private static final SdkField<String> BILLING_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("billingGroupId").getter(DescribeBillingGroupResponse.getter(DescribeBillingGroupResponse::billingGroupId)).setter(DescribeBillingGroupResponse.setter(Builder::billingGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupId").build()}).build();
    private static final SdkField<String> BILLING_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("billingGroupArn").getter(DescribeBillingGroupResponse.getter(DescribeBillingGroupResponse::billingGroupArn)).setter(DescribeBillingGroupResponse.setter(Builder::billingGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupArn").build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("version").getter(DescribeBillingGroupResponse.getter(DescribeBillingGroupResponse::version)).setter(DescribeBillingGroupResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<BillingGroupProperties> BILLING_GROUP_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("billingGroupProperties").getter(DescribeBillingGroupResponse.getter(DescribeBillingGroupResponse::billingGroupProperties)).setter(DescribeBillingGroupResponse.setter(Builder::billingGroupProperties)).constructor(BillingGroupProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupProperties").build()}).build();
    private static final SdkField<BillingGroupMetadata> BILLING_GROUP_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("billingGroupMetadata").getter(DescribeBillingGroupResponse.getter(DescribeBillingGroupResponse::billingGroupMetadata)).setter(DescribeBillingGroupResponse.setter(Builder::billingGroupMetadata)).constructor(BillingGroupMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_GROUP_NAME_FIELD, BILLING_GROUP_ID_FIELD, BILLING_GROUP_ARN_FIELD, VERSION_FIELD, BILLING_GROUP_PROPERTIES_FIELD, BILLING_GROUP_METADATA_FIELD));
    private final String billingGroupName;
    private final String billingGroupId;
    private final String billingGroupArn;
    private final Long version;
    private final BillingGroupProperties billingGroupProperties;
    private final BillingGroupMetadata billingGroupMetadata;

    private DescribeBillingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.billingGroupName = builder.billingGroupName;
        this.billingGroupId = builder.billingGroupId;
        this.billingGroupArn = builder.billingGroupArn;
        this.version = builder.version;
        this.billingGroupProperties = builder.billingGroupProperties;
        this.billingGroupMetadata = builder.billingGroupMetadata;
    }

    public final String billingGroupName() {
        return this.billingGroupName;
    }

    public final String billingGroupId() {
        return this.billingGroupId;
    }

    public final String billingGroupArn() {
        return this.billingGroupArn;
    }

    public final Long version() {
        return this.version;
    }

    public final BillingGroupProperties billingGroupProperties() {
        return this.billingGroupProperties;
    }

    public final BillingGroupMetadata billingGroupMetadata() {
        return this.billingGroupMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.billingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingGroupProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingGroupMetadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBillingGroupResponse)) {
            return false;
        }
        DescribeBillingGroupResponse other = (DescribeBillingGroupResponse)((Object)obj);
        return Objects.equals(this.billingGroupName(), other.billingGroupName()) && Objects.equals(this.billingGroupId(), other.billingGroupId()) && Objects.equals(this.billingGroupArn(), other.billingGroupArn()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.billingGroupProperties(), other.billingGroupProperties()) && Objects.equals(this.billingGroupMetadata(), other.billingGroupMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeBillingGroupResponse").add("BillingGroupName", (Object)this.billingGroupName()).add("BillingGroupId", (Object)this.billingGroupId()).add("BillingGroupArn", (Object)this.billingGroupArn()).add("Version", (Object)this.version()).add("BillingGroupProperties", (Object)this.billingGroupProperties()).add("BillingGroupMetadata", (Object)this.billingGroupMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "billingGroupName": {
                return Optional.ofNullable(clazz.cast(this.billingGroupName()));
            }
            case "billingGroupId": {
                return Optional.ofNullable(clazz.cast(this.billingGroupId()));
            }
            case "billingGroupArn": {
                return Optional.ofNullable(clazz.cast(this.billingGroupArn()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "billingGroupProperties": {
                return Optional.ofNullable(clazz.cast(this.billingGroupProperties()));
            }
            case "billingGroupMetadata": {
                return Optional.ofNullable(clazz.cast(this.billingGroupMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeBillingGroupResponse, T> g) {
        return obj -> g.apply((DescribeBillingGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String billingGroupName;
        private String billingGroupId;
        private String billingGroupArn;
        private Long version;
        private BillingGroupProperties billingGroupProperties;
        private BillingGroupMetadata billingGroupMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBillingGroupResponse model) {
            super(model);
            this.billingGroupName(model.billingGroupName);
            this.billingGroupId(model.billingGroupId);
            this.billingGroupArn(model.billingGroupArn);
            this.version(model.version);
            this.billingGroupProperties(model.billingGroupProperties);
            this.billingGroupMetadata(model.billingGroupMetadata);
        }

        public final String getBillingGroupName() {
            return this.billingGroupName;
        }

        public final void setBillingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
        }

        @Override
        public final Builder billingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
            return this;
        }

        public final String getBillingGroupId() {
            return this.billingGroupId;
        }

        public final void setBillingGroupId(String billingGroupId) {
            this.billingGroupId = billingGroupId;
        }

        @Override
        public final Builder billingGroupId(String billingGroupId) {
            this.billingGroupId = billingGroupId;
            return this;
        }

        public final String getBillingGroupArn() {
            return this.billingGroupArn;
        }

        public final void setBillingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
        }

        @Override
        public final Builder billingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
            return this;
        }

        public final Long getVersion() {
            return this.version;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final BillingGroupProperties.Builder getBillingGroupProperties() {
            return this.billingGroupProperties != null ? this.billingGroupProperties.toBuilder() : null;
        }

        public final void setBillingGroupProperties(BillingGroupProperties.BuilderImpl billingGroupProperties) {
            this.billingGroupProperties = billingGroupProperties != null ? billingGroupProperties.build() : null;
        }

        @Override
        public final Builder billingGroupProperties(BillingGroupProperties billingGroupProperties) {
            this.billingGroupProperties = billingGroupProperties;
            return this;
        }

        public final BillingGroupMetadata.Builder getBillingGroupMetadata() {
            return this.billingGroupMetadata != null ? this.billingGroupMetadata.toBuilder() : null;
        }

        public final void setBillingGroupMetadata(BillingGroupMetadata.BuilderImpl billingGroupMetadata) {
            this.billingGroupMetadata = billingGroupMetadata != null ? billingGroupMetadata.build() : null;
        }

        @Override
        public final Builder billingGroupMetadata(BillingGroupMetadata billingGroupMetadata) {
            this.billingGroupMetadata = billingGroupMetadata;
            return this;
        }

        @Override
        public DescribeBillingGroupResponse build() {
            return new DescribeBillingGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBillingGroupResponse> {
        public Builder billingGroupName(String var1);

        public Builder billingGroupId(String var1);

        public Builder billingGroupArn(String var1);

        public Builder version(Long var1);

        public Builder billingGroupProperties(BillingGroupProperties var1);

        default public Builder billingGroupProperties(Consumer<BillingGroupProperties.Builder> billingGroupProperties) {
            return this.billingGroupProperties((BillingGroupProperties)((BillingGroupProperties.Builder)BillingGroupProperties.builder().applyMutation(billingGroupProperties)).build());
        }

        public Builder billingGroupMetadata(BillingGroupMetadata var1);

        default public Builder billingGroupMetadata(Consumer<BillingGroupMetadata.Builder> billingGroupMetadata) {
            return this.billingGroupMetadata((BillingGroupMetadata)((BillingGroupMetadata.Builder)BillingGroupMetadata.builder().applyMutation(billingGroupMetadata)).build());
        }
    }
}

