/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCustomMetricRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateCustomMetricRequest> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricName").getter(UpdateCustomMetricRequest.getter(UpdateCustomMetricRequest::metricName)).setter(UpdateCustomMetricRequest.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("metricName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateCustomMetricRequest.getter(UpdateCustomMetricRequest::displayName)).setter(UpdateCustomMetricRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, DISPLAY_NAME_FIELD));
    private final String metricName;
    private final String displayName;

    private UpdateCustomMetricRequest(BuilderImpl builder) {
        super(builder);
        this.metricName = builder.metricName;
        this.displayName = builder.displayName;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String displayName() {
        return this.displayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCustomMetricRequest)) {
            return false;
        }
        UpdateCustomMetricRequest other = (UpdateCustomMetricRequest)((Object)obj);
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.displayName(), other.displayName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCustomMetricRequest").add("MetricName", (Object)this.metricName()).add("DisplayName", (Object)this.displayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCustomMetricRequest, T> g) {
        return obj -> g.apply((UpdateCustomMetricRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String metricName;
        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCustomMetricRequest model) {
            super(model);
            this.metricName(model.metricName);
            this.displayName(model.displayName);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCustomMetricRequest build() {
            return new UpdateCustomMetricRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCustomMetricRequest> {
        public Builder metricName(String var1);

        public Builder displayName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

