/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.BehaviorModelTrainingSummary;
import software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesRequest;
import software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesResponse;

public class GetBehaviorModelTrainingSummariesPublisher
implements SdkPublisher<GetBehaviorModelTrainingSummariesResponse> {
    private final IotAsyncClient client;
    private final GetBehaviorModelTrainingSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetBehaviorModelTrainingSummariesPublisher(IotAsyncClient client, GetBehaviorModelTrainingSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetBehaviorModelTrainingSummariesPublisher(IotAsyncClient client, GetBehaviorModelTrainingSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetBehaviorModelTrainingSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetBehaviorModelTrainingSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BehaviorModelTrainingSummary> summaries() {
        Function<GetBehaviorModelTrainingSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetBehaviorModelTrainingSummariesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetBehaviorModelTrainingSummariesResponseFetcher
    implements AsyncPageFetcher<GetBehaviorModelTrainingSummariesResponse> {
        private GetBehaviorModelTrainingSummariesResponseFetcher() {
        }

        public boolean hasNextPage(GetBehaviorModelTrainingSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetBehaviorModelTrainingSummariesResponse> nextPage(GetBehaviorModelTrainingSummariesResponse previousPage) {
            if (previousPage == null) {
                return GetBehaviorModelTrainingSummariesPublisher.this.client.getBehaviorModelTrainingSummaries(GetBehaviorModelTrainingSummariesPublisher.this.firstRequest);
            }
            return GetBehaviorModelTrainingSummariesPublisher.this.client.getBehaviorModelTrainingSummaries((GetBehaviorModelTrainingSummariesRequest)((Object)GetBehaviorModelTrainingSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

