/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.CACertificate;
import software.amazon.awssdk.services.iot.model.ListCaCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse;

public class ListCACertificatesPublisher
implements SdkPublisher<ListCaCertificatesResponse> {
    private final IotAsyncClient client;
    private final ListCaCertificatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCACertificatesPublisher(IotAsyncClient client, ListCaCertificatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCACertificatesPublisher(IotAsyncClient client, ListCaCertificatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCaCertificatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCaCertificatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CACertificate> certificates() {
        Function<ListCaCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.certificates() != null) {
                return response.certificates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCaCertificatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCaCertificatesResponseFetcher
    implements AsyncPageFetcher<ListCaCertificatesResponse> {
        private ListCaCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(ListCaCertificatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListCaCertificatesResponse> nextPage(ListCaCertificatesResponse previousPage) {
            if (previousPage == null) {
                return ListCACertificatesPublisher.this.client.listCACertificates(ListCACertificatesPublisher.this.firstRequest);
            }
            return ListCACertificatesPublisher.this.client.listCACertificates((ListCaCertificatesRequest)((Object)ListCACertificatesPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

