/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListDimensionsRequest;
import software.amazon.awssdk.services.iot.model.ListDimensionsResponse;

public class ListDimensionsPublisher
implements SdkPublisher<ListDimensionsResponse> {
    private final IotAsyncClient client;
    private final ListDimensionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDimensionsPublisher(IotAsyncClient client, ListDimensionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDimensionsPublisher(IotAsyncClient client, ListDimensionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDimensionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDimensionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> dimensionNames() {
        Function<ListDimensionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dimensionNames() != null) {
                return response.dimensionNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDimensionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDimensionsResponseFetcher
    implements AsyncPageFetcher<ListDimensionsResponse> {
        private ListDimensionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDimensionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDimensionsResponse> nextPage(ListDimensionsResponse previousPage) {
            if (previousPage == null) {
                return ListDimensionsPublisher.this.client.listDimensions(ListDimensionsPublisher.this.firstRequest);
            }
            return ListDimensionsPublisher.this.client.listDimensions((ListDimensionsRequest)((Object)ListDimensionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

