/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.DomainConfigurationSummary;
import software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest;
import software.amazon.awssdk.services.iot.model.ListDomainConfigurationsResponse;

public class ListDomainConfigurationsPublisher
implements SdkPublisher<ListDomainConfigurationsResponse> {
    private final IotAsyncClient client;
    private final ListDomainConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDomainConfigurationsPublisher(IotAsyncClient client, ListDomainConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDomainConfigurationsPublisher(IotAsyncClient client, ListDomainConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDomainConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDomainConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DomainConfigurationSummary> domainConfigurations() {
        Function<ListDomainConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.domainConfigurations() != null) {
                return response.domainConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDomainConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDomainConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListDomainConfigurationsResponse> {
        private ListDomainConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListDomainConfigurationsResponse> nextPage(ListDomainConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListDomainConfigurationsPublisher.this.client.listDomainConfigurations(ListDomainConfigurationsPublisher.this.firstRequest);
            }
            return ListDomainConfigurationsPublisher.this.client.listDomainConfigurations((ListDomainConfigurationsRequest)((Object)ListDomainConfigurationsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

