/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.FleetMetricNameAndArn;
import software.amazon.awssdk.services.iot.model.ListFleetMetricsRequest;
import software.amazon.awssdk.services.iot.model.ListFleetMetricsResponse;

public class ListFleetMetricsPublisher
implements SdkPublisher<ListFleetMetricsResponse> {
    private final IotAsyncClient client;
    private final ListFleetMetricsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFleetMetricsPublisher(IotAsyncClient client, ListFleetMetricsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFleetMetricsPublisher(IotAsyncClient client, ListFleetMetricsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFleetMetricsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFleetMetricsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FleetMetricNameAndArn> fleetMetrics() {
        Function<ListFleetMetricsResponse, Iterator> getIterator = response -> {
            if (response != null && response.fleetMetrics() != null) {
                return response.fleetMetrics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFleetMetricsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFleetMetricsResponseFetcher
    implements AsyncPageFetcher<ListFleetMetricsResponse> {
        private ListFleetMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListFleetMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFleetMetricsResponse> nextPage(ListFleetMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListFleetMetricsPublisher.this.client.listFleetMetrics(ListFleetMetricsPublisher.this.firstRequest);
            }
            return ListFleetMetricsPublisher.this.client.listFleetMetrics((ListFleetMetricsRequest)((Object)ListFleetMetricsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

