/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor;

import java.net.URI;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.AwsServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotdeviceadvisor.auth.scheme.IotDeviceAdvisorAuthSchemeProvider;
import software.amazon.awssdk.services.iotdeviceadvisor.internal.IotDeviceAdvisorServiceClientConfigurationBuilder;

@SdkPublicApi
public final class IotDeviceAdvisorServiceClientConfiguration
extends AwsServiceClientConfiguration {
    private final IotDeviceAdvisorAuthSchemeProvider authSchemeProvider;

    public IotDeviceAdvisorServiceClientConfiguration(Builder builder) {
        super((AwsServiceClientConfiguration.Builder)builder);
        this.authSchemeProvider = builder.authSchemeProvider();
    }

    public IotDeviceAdvisorAuthSchemeProvider authSchemeProvider() {
        return this.authSchemeProvider;
    }

    public static Builder builder() {
        return IotDeviceAdvisorServiceClientConfigurationBuilder.builder();
    }

    public static interface Builder
    extends AwsServiceClientConfiguration.Builder {
        public Builder overrideConfiguration(ClientOverrideConfiguration var1);

        public ClientOverrideConfiguration overrideConfiguration();

        public Builder endpointOverride(URI var1);

        public URI endpointOverride();

        public Builder endpointProvider(EndpointProvider var1);

        public EndpointProvider endpointProvider();

        public Builder region(Region var1);

        public Region region();

        public Builder credentialsProvider(IdentityProvider<? extends AwsCredentialsIdentity> var1);

        public IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider();

        public Builder putAuthScheme(AuthScheme<?> var1);

        public Map<String, AuthScheme<?>> authSchemes();

        public Builder authSchemeProvider(IotDeviceAdvisorAuthSchemeProvider var1);

        public IotDeviceAdvisorAuthSchemeProvider authSchemeProvider();

        public IotDeviceAdvisorServiceClientConfiguration build();
    }
}

