/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotevents.DefaultIotEventsAsyncClient;
import software.amazon.awssdk.services.iotevents.DefaultIotEventsBaseClientBuilder;
import software.amazon.awssdk.services.iotevents.IotEventsAsyncClient;
import software.amazon.awssdk.services.iotevents.IotEventsAsyncClientBuilder;
import software.amazon.awssdk.services.iotevents.IotEventsServiceClientConfiguration;
import software.amazon.awssdk.services.iotevents.endpoints.IotEventsEndpointProvider;

@SdkInternalApi
final class DefaultIotEventsAsyncClientBuilder
extends DefaultIotEventsBaseClientBuilder<IotEventsAsyncClientBuilder, IotEventsAsyncClient>
implements IotEventsAsyncClientBuilder {
    DefaultIotEventsAsyncClientBuilder() {
    }

    @Override
    public DefaultIotEventsAsyncClientBuilder endpointProvider(IotEventsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IotEventsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultIotEventsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        IotEventsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIotEventsAsyncClient client = new DefaultIotEventsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IotEventsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IotEventsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

