/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotevents.DefaultIotEventsBaseClientBuilder;
import software.amazon.awssdk.services.iotevents.DefaultIotEventsClient;
import software.amazon.awssdk.services.iotevents.IotEventsClient;
import software.amazon.awssdk.services.iotevents.IotEventsClientBuilder;
import software.amazon.awssdk.services.iotevents.IotEventsServiceClientConfiguration;
import software.amazon.awssdk.services.iotevents.endpoints.IotEventsEndpointProvider;

@SdkInternalApi
final class DefaultIotEventsClientBuilder
extends DefaultIotEventsBaseClientBuilder<IotEventsClientBuilder, IotEventsClient>
implements IotEventsClientBuilder {
    DefaultIotEventsClientBuilder() {
    }

    @Override
    public DefaultIotEventsClientBuilder endpointProvider(IotEventsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IotEventsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultIotEventsClientBuilder.validateClientOptions(clientConfiguration);
        IotEventsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIotEventsClient client = new DefaultIotEventsClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IotEventsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IotEventsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

