/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotevents.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DetectorModelVersionStatus {
    ACTIVE("ACTIVE"),
    ACTIVATING("ACTIVATING"),
    INACTIVE("INACTIVE"),
    DEPRECATED("DEPRECATED"),
    DRAFT("DRAFT"),
    PAUSED("PAUSED"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DetectorModelVersionStatus> VALUE_MAP;
    private final String value;

    private DetectorModelVersionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DetectorModelVersionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DetectorModelVersionStatus> knownValues() {
        EnumSet<DetectorModelVersionStatus> knownValues = EnumSet.allOf(DetectorModelVersionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DetectorModelVersionStatus.class, DetectorModelVersionStatus::toString);
    }
}

