/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseRequest;
import software.amazon.awssdk.services.iotfleetwise.model.Tag;
import software.amazon.awssdk.services.iotfleetwise.model.TagListCopier;
import software.amazon.awssdk.services.iotfleetwise.model.VehicleAssociationBehavior;
import software.amazon.awssdk.services.iotfleetwise.model._attributesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVehicleRequest
extends IoTFleetWiseRequest
implements ToCopyableBuilder<Builder, CreateVehicleRequest> {
    private static final SdkField<String> VEHICLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vehicleName").getter(CreateVehicleRequest.getter(CreateVehicleRequest::vehicleName)).setter(CreateVehicleRequest.setter(Builder::vehicleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicleName").build()}).build();
    private static final SdkField<String> MODEL_MANIFEST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelManifestArn").getter(CreateVehicleRequest.getter(CreateVehicleRequest::modelManifestArn)).setter(CreateVehicleRequest.setter(Builder::modelManifestArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelManifestArn").build()}).build();
    private static final SdkField<String> DECODER_MANIFEST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("decoderManifestArn").getter(CreateVehicleRequest.getter(CreateVehicleRequest::decoderManifestArn)).setter(CreateVehicleRequest.setter(Builder::decoderManifestArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decoderManifestArn").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(CreateVehicleRequest.getter(CreateVehicleRequest::attributes)).setter(CreateVehicleRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ASSOCIATION_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationBehavior").getter(CreateVehicleRequest.getter(CreateVehicleRequest::associationBehaviorAsString)).setter(CreateVehicleRequest.setter(Builder::associationBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationBehavior").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateVehicleRequest.getter(CreateVehicleRequest::tags)).setter(CreateVehicleRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VEHICLE_NAME_FIELD, MODEL_MANIFEST_ARN_FIELD, DECODER_MANIFEST_ARN_FIELD, ATTRIBUTES_FIELD, ASSOCIATION_BEHAVIOR_FIELD, TAGS_FIELD));
    private final String vehicleName;
    private final String modelManifestArn;
    private final String decoderManifestArn;
    private final Map<String, String> attributes;
    private final String associationBehavior;
    private final List<Tag> tags;

    private CreateVehicleRequest(BuilderImpl builder) {
        super(builder);
        this.vehicleName = builder.vehicleName;
        this.modelManifestArn = builder.modelManifestArn;
        this.decoderManifestArn = builder.decoderManifestArn;
        this.attributes = builder.attributes;
        this.associationBehavior = builder.associationBehavior;
        this.tags = builder.tags;
    }

    public final String vehicleName() {
        return this.vehicleName;
    }

    public final String modelManifestArn() {
        return this.modelManifestArn;
    }

    public final String decoderManifestArn() {
        return this.decoderManifestArn;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final VehicleAssociationBehavior associationBehavior() {
        return VehicleAssociationBehavior.fromValue(this.associationBehavior);
    }

    public final String associationBehaviorAsString() {
        return this.associationBehavior;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vehicleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelManifestArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.decoderManifestArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.associationBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVehicleRequest)) {
            return false;
        }
        CreateVehicleRequest other = (CreateVehicleRequest)((Object)obj);
        return Objects.equals(this.vehicleName(), other.vehicleName()) && Objects.equals(this.modelManifestArn(), other.modelManifestArn()) && Objects.equals(this.decoderManifestArn(), other.decoderManifestArn()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.associationBehaviorAsString(), other.associationBehaviorAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVehicleRequest").add("VehicleName", (Object)this.vehicleName()).add("ModelManifestArn", (Object)this.modelManifestArn()).add("DecoderManifestArn", (Object)this.decoderManifestArn()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("AssociationBehavior", (Object)this.associationBehaviorAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vehicleName": {
                return Optional.ofNullable(clazz.cast(this.vehicleName()));
            }
            case "modelManifestArn": {
                return Optional.ofNullable(clazz.cast(this.modelManifestArn()));
            }
            case "decoderManifestArn": {
                return Optional.ofNullable(clazz.cast(this.decoderManifestArn()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "associationBehavior": {
                return Optional.ofNullable(clazz.cast(this.associationBehaviorAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVehicleRequest, T> g) {
        return obj -> g.apply((CreateVehicleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseRequest.BuilderImpl
    implements Builder {
        private String vehicleName;
        private String modelManifestArn;
        private String decoderManifestArn;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String associationBehavior;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVehicleRequest model) {
            super(model);
            this.vehicleName(model.vehicleName);
            this.modelManifestArn(model.modelManifestArn);
            this.decoderManifestArn(model.decoderManifestArn);
            this.attributes(model.attributes);
            this.associationBehavior(model.associationBehavior);
            this.tags(model.tags);
        }

        public final String getVehicleName() {
            return this.vehicleName;
        }

        public final void setVehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
        }

        @Override
        public final Builder vehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
            return this;
        }

        public final String getModelManifestArn() {
            return this.modelManifestArn;
        }

        public final void setModelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
        }

        @Override
        public final Builder modelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
            return this;
        }

        public final String getDecoderManifestArn() {
            return this.decoderManifestArn;
        }

        public final void setDecoderManifestArn(String decoderManifestArn) {
            this.decoderManifestArn = decoderManifestArn;
        }

        @Override
        public final Builder decoderManifestArn(String decoderManifestArn) {
            this.decoderManifestArn = decoderManifestArn;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = _attributesMapCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = _attributesMapCopier.copy(attributes);
            return this;
        }

        public final String getAssociationBehavior() {
            return this.associationBehavior;
        }

        public final void setAssociationBehavior(String associationBehavior) {
            this.associationBehavior = associationBehavior;
        }

        @Override
        public final Builder associationBehavior(String associationBehavior) {
            this.associationBehavior = associationBehavior;
            return this;
        }

        @Override
        public final Builder associationBehavior(VehicleAssociationBehavior associationBehavior) {
            this.associationBehavior(associationBehavior == null ? null : associationBehavior.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVehicleRequest build() {
            return new CreateVehicleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTFleetWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVehicleRequest> {
        public Builder vehicleName(String var1);

        public Builder modelManifestArn(String var1);

        public Builder decoderManifestArn(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder associationBehavior(String var1);

        public Builder associationBehavior(VehicleAssociationBehavior var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

