/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseResponse;
import software.amazon.awssdk.services.iotfleetwise.model.SignalDecoder;
import software.amazon.awssdk.services.iotfleetwise.model.SignalDecodersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDecoderManifestSignalsResponse
extends IoTFleetWiseResponse
implements ToCopyableBuilder<Builder, ListDecoderManifestSignalsResponse> {
    private static final SdkField<List<SignalDecoder>> SIGNAL_DECODERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("signalDecoders").getter(ListDecoderManifestSignalsResponse.getter(ListDecoderManifestSignalsResponse::signalDecoders)).setter(ListDecoderManifestSignalsResponse.setter(Builder::signalDecoders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalDecoders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SignalDecoder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDecoderManifestSignalsResponse.getter(ListDecoderManifestSignalsResponse::nextToken)).setter(ListDecoderManifestSignalsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNAL_DECODERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<SignalDecoder> signalDecoders;
    private final String nextToken;

    private ListDecoderManifestSignalsResponse(BuilderImpl builder) {
        super(builder);
        this.signalDecoders = builder.signalDecoders;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSignalDecoders() {
        return this.signalDecoders != null && !(this.signalDecoders instanceof SdkAutoConstructList);
    }

    public final List<SignalDecoder> signalDecoders() {
        return this.signalDecoders;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSignalDecoders() ? this.signalDecoders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDecoderManifestSignalsResponse)) {
            return false;
        }
        ListDecoderManifestSignalsResponse other = (ListDecoderManifestSignalsResponse)((Object)obj);
        return this.hasSignalDecoders() == other.hasSignalDecoders() && Objects.equals(this.signalDecoders(), other.signalDecoders()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDecoderManifestSignalsResponse").add("SignalDecoders", this.hasSignalDecoders() ? this.signalDecoders() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "signalDecoders": {
                return Optional.ofNullable(clazz.cast(this.signalDecoders()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDecoderManifestSignalsResponse, T> g) {
        return obj -> g.apply((ListDecoderManifestSignalsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseResponse.BuilderImpl
    implements Builder {
        private List<SignalDecoder> signalDecoders = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDecoderManifestSignalsResponse model) {
            super(model);
            this.signalDecoders(model.signalDecoders);
            this.nextToken(model.nextToken);
        }

        public final List<SignalDecoder.Builder> getSignalDecoders() {
            List<SignalDecoder.Builder> result = SignalDecodersCopier.copyToBuilder(this.signalDecoders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignalDecoders(Collection<SignalDecoder.BuilderImpl> signalDecoders) {
            this.signalDecoders = SignalDecodersCopier.copyFromBuilder(signalDecoders);
        }

        @Override
        public final Builder signalDecoders(Collection<SignalDecoder> signalDecoders) {
            this.signalDecoders = SignalDecodersCopier.copy(signalDecoders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalDecoders(SignalDecoder ... signalDecoders) {
            this.signalDecoders(Arrays.asList(signalDecoders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalDecoders(Consumer<SignalDecoder.Builder> ... signalDecoders) {
            this.signalDecoders(Stream.of(signalDecoders).map(c -> (SignalDecoder)((SignalDecoder.Builder)SignalDecoder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDecoderManifestSignalsResponse build() {
            return new ListDecoderManifestSignalsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTFleetWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDecoderManifestSignalsResponse> {
        public Builder signalDecoders(Collection<SignalDecoder> var1);

        public Builder signalDecoders(SignalDecoder ... var1);

        public Builder signalDecoders(Consumer<SignalDecoder.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

