/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseAsyncClient;
import software.amazon.awssdk.services.iotfleetwise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.NetworkInterface;

public class ListDecoderManifestNetworkInterfacesPublisher
implements SdkPublisher<ListDecoderManifestNetworkInterfacesResponse> {
    private final IoTFleetWiseAsyncClient client;
    private final ListDecoderManifestNetworkInterfacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDecoderManifestNetworkInterfacesPublisher(IoTFleetWiseAsyncClient client, ListDecoderManifestNetworkInterfacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDecoderManifestNetworkInterfacesPublisher(IoTFleetWiseAsyncClient client, ListDecoderManifestNetworkInterfacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDecoderManifestNetworkInterfacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDecoderManifestNetworkInterfacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<NetworkInterface> networkInterfaces() {
        Function<ListDecoderManifestNetworkInterfacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkInterfaces() != null) {
                return response.networkInterfaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDecoderManifestNetworkInterfacesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDecoderManifestNetworkInterfacesResponseFetcher
    implements AsyncPageFetcher<ListDecoderManifestNetworkInterfacesResponse> {
        private ListDecoderManifestNetworkInterfacesResponseFetcher() {
        }

        public boolean hasNextPage(ListDecoderManifestNetworkInterfacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDecoderManifestNetworkInterfacesResponse> nextPage(ListDecoderManifestNetworkInterfacesResponse previousPage) {
            if (previousPage == null) {
                return ListDecoderManifestNetworkInterfacesPublisher.this.client.listDecoderManifestNetworkInterfaces(ListDecoderManifestNetworkInterfacesPublisher.this.firstRequest);
            }
            return ListDecoderManifestNetworkInterfacesPublisher.this.client.listDecoderManifestNetworkInterfaces((ListDecoderManifestNetworkInterfacesRequest)((Object)ListDecoderManifestNetworkInterfacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

