/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.AssetModelSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssetModelsResponse;

public class ListAssetModelsIterable
implements SdkIterable<ListAssetModelsResponse> {
    private final IoTSiteWiseClient client;
    private final ListAssetModelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssetModelsIterable(IoTSiteWiseClient client, ListAssetModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAssetModelsResponseFetcher();
    }

    public Iterator<ListAssetModelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssetModelSummary> assetModelSummaries() {
        Function<ListAssetModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetModelSummaries() != null) {
                return response.assetModelSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssetModelsResponseFetcher
    implements SyncPageFetcher<ListAssetModelsResponse> {
        private ListAssetModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssetModelsResponse nextPage(ListAssetModelsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetModelsIterable.this.client.listAssetModels(ListAssetModelsIterable.this.firstRequest);
            }
            return ListAssetModelsIterable.this.client.listAssetModels((ListAssetModelsRequest)((Object)ListAssetModelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

