/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotthingsgraph.DefaultIoTThingsGraphAsyncClient;
import software.amazon.awssdk.services.iotthingsgraph.DefaultIoTThingsGraphBaseClientBuilder;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphAsyncClient;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphAsyncClientBuilder;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphServiceClientConfiguration;
import software.amazon.awssdk.services.iotthingsgraph.endpoints.IoTThingsGraphEndpointProvider;

@SdkInternalApi
final class DefaultIoTThingsGraphAsyncClientBuilder
extends DefaultIoTThingsGraphBaseClientBuilder<IoTThingsGraphAsyncClientBuilder, IoTThingsGraphAsyncClient>
implements IoTThingsGraphAsyncClientBuilder {
    DefaultIoTThingsGraphAsyncClientBuilder() {
    }

    @Override
    public DefaultIoTThingsGraphAsyncClientBuilder endpointProvider(IoTThingsGraphEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IoTThingsGraphAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultIoTThingsGraphAsyncClientBuilder.validateClientOptions(clientConfiguration);
        IoTThingsGraphServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIoTThingsGraphAsyncClient client = new DefaultIoTThingsGraphAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IoTThingsGraphServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IoTThingsGraphServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

