/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphClient;
import software.amazon.awssdk.services.iotthingsgraph.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotthingsgraph.model.FlowTemplateSummary;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse;

public class GetFlowTemplateRevisionsIterable
implements SdkIterable<GetFlowTemplateRevisionsResponse> {
    private final IoTThingsGraphClient client;
    private final GetFlowTemplateRevisionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetFlowTemplateRevisionsIterable(IoTThingsGraphClient client, GetFlowTemplateRevisionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetFlowTemplateRevisionsResponseFetcher();
    }

    public Iterator<GetFlowTemplateRevisionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FlowTemplateSummary> summaries() {
        Function<GetFlowTemplateRevisionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetFlowTemplateRevisionsResponseFetcher
    implements SyncPageFetcher<GetFlowTemplateRevisionsResponse> {
        private GetFlowTemplateRevisionsResponseFetcher() {
        }

        public boolean hasNextPage(GetFlowTemplateRevisionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetFlowTemplateRevisionsResponse nextPage(GetFlowTemplateRevisionsResponse previousPage) {
            if (previousPage == null) {
                return GetFlowTemplateRevisionsIterable.this.client.getFlowTemplateRevisions(GetFlowTemplateRevisionsIterable.this.firstRequest);
            }
            return GetFlowTemplateRevisionsIterable.this.client.getFlowTemplateRevisions((GetFlowTemplateRevisionsRequest)((Object)GetFlowTemplateRevisionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

