/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ivsrealtime.DefaultIvsRealTimeAsyncClient;
import software.amazon.awssdk.services.ivsrealtime.DefaultIvsRealTimeBaseClientBuilder;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeAsyncClient;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeAsyncClientBuilder;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeServiceClientConfiguration;
import software.amazon.awssdk.services.ivsrealtime.endpoints.IvsRealTimeEndpointProvider;

@SdkInternalApi
final class DefaultIvsRealTimeAsyncClientBuilder
extends DefaultIvsRealTimeBaseClientBuilder<IvsRealTimeAsyncClientBuilder, IvsRealTimeAsyncClient>
implements IvsRealTimeAsyncClientBuilder {
    DefaultIvsRealTimeAsyncClientBuilder() {
    }

    @Override
    public DefaultIvsRealTimeAsyncClientBuilder endpointProvider(IvsRealTimeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IvsRealTimeAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultIvsRealTimeAsyncClientBuilder.validateClientOptions(clientConfiguration);
        IvsRealTimeServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIvsRealTimeAsyncClient client = new DefaultIvsRealTimeAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IvsRealTimeServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IvsRealTimeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

