/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ivsrealtime.DefaultIvsRealTimeBaseClientBuilder;
import software.amazon.awssdk.services.ivsrealtime.DefaultIvsRealTimeClient;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeClient;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeClientBuilder;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeServiceClientConfiguration;
import software.amazon.awssdk.services.ivsrealtime.endpoints.IvsRealTimeEndpointProvider;

@SdkInternalApi
final class DefaultIvsRealTimeClientBuilder
extends DefaultIvsRealTimeBaseClientBuilder<IvsRealTimeClientBuilder, IvsRealTimeClient>
implements IvsRealTimeClientBuilder {
    DefaultIvsRealTimeClientBuilder() {
    }

    @Override
    public DefaultIvsRealTimeClientBuilder endpointProvider(IvsRealTimeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IvsRealTimeClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultIvsRealTimeClientBuilder.validateClientOptions(clientConfiguration);
        IvsRealTimeServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIvsRealTimeClient client = new DefaultIvsRealTimeClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IvsRealTimeServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IvsRealTimeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

