/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.ClientAuthentication;
import software.amazon.awssdk.services.kafka.model.EncryptionInfo;
import software.amazon.awssdk.services.kafka.model.KafkaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSecurityRequest
extends KafkaRequest
implements ToCopyableBuilder<Builder, UpdateSecurityRequest> {
    private static final SdkField<ClientAuthentication> CLIENT_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientAuthentication").getter(UpdateSecurityRequest.getter(UpdateSecurityRequest::clientAuthentication)).setter(UpdateSecurityRequest.setter(Builder::clientAuthentication)).constructor(ClientAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientAuthentication").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(UpdateSecurityRequest.getter(UpdateSecurityRequest::clusterArn)).setter(UpdateSecurityRequest.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentVersion").getter(UpdateSecurityRequest.getter(UpdateSecurityRequest::currentVersion)).setter(UpdateSecurityRequest.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()}).build();
    private static final SdkField<EncryptionInfo> ENCRYPTION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionInfo").getter(UpdateSecurityRequest.getter(UpdateSecurityRequest::encryptionInfo)).setter(UpdateSecurityRequest.setter(Builder::encryptionInfo)).constructor(EncryptionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_AUTHENTICATION_FIELD, CLUSTER_ARN_FIELD, CURRENT_VERSION_FIELD, ENCRYPTION_INFO_FIELD));
    private final ClientAuthentication clientAuthentication;
    private final String clusterArn;
    private final String currentVersion;
    private final EncryptionInfo encryptionInfo;

    private UpdateSecurityRequest(BuilderImpl builder) {
        super(builder);
        this.clientAuthentication = builder.clientAuthentication;
        this.clusterArn = builder.clusterArn;
        this.currentVersion = builder.currentVersion;
        this.encryptionInfo = builder.encryptionInfo;
    }

    public final ClientAuthentication clientAuthentication() {
        return this.clientAuthentication;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String currentVersion() {
        return this.currentVersion;
    }

    public final EncryptionInfo encryptionInfo() {
        return this.encryptionInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityRequest)) {
            return false;
        }
        UpdateSecurityRequest other = (UpdateSecurityRequest)((Object)obj);
        return Objects.equals(this.clientAuthentication(), other.clientAuthentication()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.encryptionInfo(), other.encryptionInfo());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSecurityRequest").add("ClientAuthentication", (Object)this.clientAuthentication()).add("ClusterArn", (Object)this.clusterArn()).add("CurrentVersion", (Object)this.currentVersion()).add("EncryptionInfo", (Object)this.encryptionInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientAuthentication": {
                return Optional.ofNullable(clazz.cast(this.clientAuthentication()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "EncryptionInfo": {
                return Optional.ofNullable(clazz.cast(this.encryptionInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityRequest, T> g) {
        return obj -> g.apply((UpdateSecurityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaRequest.BuilderImpl
    implements Builder {
        private ClientAuthentication clientAuthentication;
        private String clusterArn;
        private String currentVersion;
        private EncryptionInfo encryptionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityRequest model) {
            super(model);
            this.clientAuthentication(model.clientAuthentication);
            this.clusterArn(model.clusterArn);
            this.currentVersion(model.currentVersion);
            this.encryptionInfo(model.encryptionInfo);
        }

        public final ClientAuthentication.Builder getClientAuthentication() {
            return this.clientAuthentication != null ? this.clientAuthentication.toBuilder() : null;
        }

        public final void setClientAuthentication(ClientAuthentication.BuilderImpl clientAuthentication) {
            this.clientAuthentication = clientAuthentication != null ? clientAuthentication.build() : null;
        }

        @Override
        public final Builder clientAuthentication(ClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final EncryptionInfo.Builder getEncryptionInfo() {
            return this.encryptionInfo != null ? this.encryptionInfo.toBuilder() : null;
        }

        public final void setEncryptionInfo(EncryptionInfo.BuilderImpl encryptionInfo) {
            this.encryptionInfo = encryptionInfo != null ? encryptionInfo.build() : null;
        }

        @Override
        public final Builder encryptionInfo(EncryptionInfo encryptionInfo) {
            this.encryptionInfo = encryptionInfo;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityRequest build() {
            return new UpdateSecurityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KafkaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSecurityRequest> {
        public Builder clientAuthentication(ClientAuthentication var1);

        default public Builder clientAuthentication(Consumer<ClientAuthentication.Builder> clientAuthentication) {
            return this.clientAuthentication((ClientAuthentication)((ClientAuthentication.Builder)ClientAuthentication.builder().applyMutation(clientAuthentication)).build());
        }

        public Builder clusterArn(String var1);

        public Builder currentVersion(String var1);

        public Builder encryptionInfo(EncryptionInfo var1);

        default public Builder encryptionInfo(Consumer<EncryptionInfo.Builder> encryptionInfo) {
            return this.encryptionInfo((EncryptionInfo)((EncryptionInfo.Builder)EncryptionInfo.builder().applyMutation(encryptionInfo)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

