/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lakeformation.model.AddObjectInput;
import software.amazon.awssdk.services.lakeformation.model.DeleteObjectInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WriteOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WriteOperation> {
    private static final SdkField<AddObjectInput> ADD_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AddObject").getter(WriteOperation.getter(WriteOperation::addObject)).setter(WriteOperation.setter(Builder::addObject)).constructor(AddObjectInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddObject").build()}).build();
    private static final SdkField<DeleteObjectInput> DELETE_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeleteObject").getter(WriteOperation.getter(WriteOperation::deleteObject)).setter(WriteOperation.setter(Builder::deleteObject)).constructor(DeleteObjectInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteObject").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_OBJECT_FIELD, DELETE_OBJECT_FIELD));
    private static final long serialVersionUID = 1L;
    private final AddObjectInput addObject;
    private final DeleteObjectInput deleteObject;

    private WriteOperation(BuilderImpl builder) {
        this.addObject = builder.addObject;
        this.deleteObject = builder.deleteObject;
    }

    public final AddObjectInput addObject() {
        return this.addObject;
    }

    public final DeleteObjectInput deleteObject() {
        return this.deleteObject;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.addObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteObject());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteOperation)) {
            return false;
        }
        WriteOperation other = (WriteOperation)obj;
        return Objects.equals(this.addObject(), other.addObject()) && Objects.equals(this.deleteObject(), other.deleteObject());
    }

    public final String toString() {
        return ToString.builder((String)"WriteOperation").add("AddObject", (Object)this.addObject()).add("DeleteObject", (Object)this.deleteObject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddObject": {
                return Optional.ofNullable(clazz.cast(this.addObject()));
            }
            case "DeleteObject": {
                return Optional.ofNullable(clazz.cast(this.deleteObject()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WriteOperation, T> g) {
        return obj -> g.apply((WriteOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AddObjectInput addObject;
        private DeleteObjectInput deleteObject;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteOperation model) {
            this.addObject(model.addObject);
            this.deleteObject(model.deleteObject);
        }

        public final AddObjectInput.Builder getAddObject() {
            return this.addObject != null ? this.addObject.toBuilder() : null;
        }

        public final void setAddObject(AddObjectInput.BuilderImpl addObject) {
            this.addObject = addObject != null ? addObject.build() : null;
        }

        @Override
        public final Builder addObject(AddObjectInput addObject) {
            this.addObject = addObject;
            return this;
        }

        public final DeleteObjectInput.Builder getDeleteObject() {
            return this.deleteObject != null ? this.deleteObject.toBuilder() : null;
        }

        public final void setDeleteObject(DeleteObjectInput.BuilderImpl deleteObject) {
            this.deleteObject = deleteObject != null ? deleteObject.build() : null;
        }

        @Override
        public final Builder deleteObject(DeleteObjectInput deleteObject) {
            this.deleteObject = deleteObject;
            return this;
        }

        public WriteOperation build() {
            return new WriteOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WriteOperation> {
        public Builder addObject(AddObjectInput var1);

        default public Builder addObject(Consumer<AddObjectInput.Builder> addObject) {
            return this.addObject((AddObjectInput)((AddObjectInput.Builder)AddObjectInput.builder().applyMutation(addObject)).build());
        }

        public Builder deleteObject(DeleteObjectInput var1);

        default public Builder deleteObject(Consumer<DeleteObjectInput.Builder> deleteObject) {
            return this.deleteObject((DeleteObjectInput)((DeleteObjectInput.Builder)DeleteObjectInput.builder().applyMutation(deleteObject)).build());
        }
    }
}

