/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.InputContext;
import software.amazon.awssdk.services.lexmodelsv2.model.InputContextsListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.OutputContext;
import software.amazon.awssdk.services.lexmodelsv2.model.OutputContextsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IntentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IntentSummary> {
    private static final SdkField<String> INTENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentId").getter(IntentSummary.getter(IntentSummary::intentId)).setter(IntentSummary.setter(Builder::intentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentId").build()}).build();
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentName").getter(IntentSummary.getter(IntentSummary::intentName)).setter(IntentSummary.setter(Builder::intentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(IntentSummary.getter(IntentSummary::description)).setter(IntentSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> PARENT_INTENT_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentIntentSignature").getter(IntentSummary.getter(IntentSummary::parentIntentSignature)).setter(IntentSummary.setter(Builder::parentIntentSignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIntentSignature").build()}).build();
    private static final SdkField<List<InputContext>> INPUT_CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputContexts").getter(IntentSummary.getter(IntentSummary::inputContexts)).setter(IntentSummary.setter(Builder::inputContexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputContexts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OutputContext>> OUTPUT_CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputContexts").getter(IntentSummary.getter(IntentSummary::outputContexts)).setter(IntentSummary.setter(Builder::outputContexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputContexts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(IntentSummary.getter(IntentSummary::lastUpdatedDateTime)).setter(IntentSummary.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_ID_FIELD, INTENT_NAME_FIELD, DESCRIPTION_FIELD, PARENT_INTENT_SIGNATURE_FIELD, INPUT_CONTEXTS_FIELD, OUTPUT_CONTEXTS_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String intentId;
    private final String intentName;
    private final String description;
    private final String parentIntentSignature;
    private final List<InputContext> inputContexts;
    private final List<OutputContext> outputContexts;
    private final Instant lastUpdatedDateTime;

    private IntentSummary(BuilderImpl builder) {
        this.intentId = builder.intentId;
        this.intentName = builder.intentName;
        this.description = builder.description;
        this.parentIntentSignature = builder.parentIntentSignature;
        this.inputContexts = builder.inputContexts;
        this.outputContexts = builder.outputContexts;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String intentId() {
        return this.intentId;
    }

    public final String intentName() {
        return this.intentName;
    }

    public final String description() {
        return this.description;
    }

    public final String parentIntentSignature() {
        return this.parentIntentSignature;
    }

    public final boolean hasInputContexts() {
        return this.inputContexts != null && !(this.inputContexts instanceof SdkAutoConstructList);
    }

    public final List<InputContext> inputContexts() {
        return this.inputContexts;
    }

    public final boolean hasOutputContexts() {
        return this.outputContexts != null && !(this.outputContexts instanceof SdkAutoConstructList);
    }

    public final List<OutputContext> outputContexts() {
        return this.outputContexts;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentIntentSignature());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputContexts() ? this.inputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputContexts() ? this.outputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntentSummary)) {
            return false;
        }
        IntentSummary other = (IntentSummary)obj;
        return Objects.equals(this.intentId(), other.intentId()) && Objects.equals(this.intentName(), other.intentName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.parentIntentSignature(), other.parentIntentSignature()) && this.hasInputContexts() == other.hasInputContexts() && Objects.equals(this.inputContexts(), other.inputContexts()) && this.hasOutputContexts() == other.hasOutputContexts() && Objects.equals(this.outputContexts(), other.outputContexts()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"IntentSummary").add("IntentId", (Object)this.intentId()).add("IntentName", (Object)this.intentName()).add("Description", (Object)this.description()).add("ParentIntentSignature", (Object)this.parentIntentSignature()).add("InputContexts", this.hasInputContexts() ? this.inputContexts() : null).add("OutputContexts", this.hasOutputContexts() ? this.outputContexts() : null).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "intentId": {
                return Optional.ofNullable(clazz.cast(this.intentId()));
            }
            case "intentName": {
                return Optional.ofNullable(clazz.cast(this.intentName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "parentIntentSignature": {
                return Optional.ofNullable(clazz.cast(this.parentIntentSignature()));
            }
            case "inputContexts": {
                return Optional.ofNullable(clazz.cast(this.inputContexts()));
            }
            case "outputContexts": {
                return Optional.ofNullable(clazz.cast(this.outputContexts()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntentSummary, T> g) {
        return obj -> g.apply((IntentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String intentId;
        private String intentName;
        private String description;
        private String parentIntentSignature;
        private List<InputContext> inputContexts = DefaultSdkAutoConstructList.getInstance();
        private List<OutputContext> outputContexts = DefaultSdkAutoConstructList.getInstance();
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(IntentSummary model) {
            this.intentId(model.intentId);
            this.intentName(model.intentName);
            this.description(model.description);
            this.parentIntentSignature(model.parentIntentSignature);
            this.inputContexts(model.inputContexts);
            this.outputContexts(model.outputContexts);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getIntentId() {
            return this.intentId;
        }

        public final void setIntentId(String intentId) {
            this.intentId = intentId;
        }

        @Override
        public final Builder intentId(String intentId) {
            this.intentId = intentId;
            return this;
        }

        public final String getIntentName() {
            return this.intentName;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getParentIntentSignature() {
            return this.parentIntentSignature;
        }

        public final void setParentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
        }

        @Override
        public final Builder parentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
            return this;
        }

        public final List<InputContext.Builder> getInputContexts() {
            List<InputContext.Builder> result = InputContextsListCopier.copyToBuilder(this.inputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputContexts(Collection<InputContext.BuilderImpl> inputContexts) {
            this.inputContexts = InputContextsListCopier.copyFromBuilder(inputContexts);
        }

        @Override
        public final Builder inputContexts(Collection<InputContext> inputContexts) {
            this.inputContexts = InputContextsListCopier.copy(inputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(InputContext ... inputContexts) {
            this.inputContexts(Arrays.asList(inputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(Consumer<InputContext.Builder> ... inputContexts) {
            this.inputContexts(Stream.of(inputContexts).map(c -> (InputContext)((InputContext.Builder)InputContext.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OutputContext.Builder> getOutputContexts() {
            List<OutputContext.Builder> result = OutputContextsListCopier.copyToBuilder(this.outputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputContexts(Collection<OutputContext.BuilderImpl> outputContexts) {
            this.outputContexts = OutputContextsListCopier.copyFromBuilder(outputContexts);
        }

        @Override
        public final Builder outputContexts(Collection<OutputContext> outputContexts) {
            this.outputContexts = OutputContextsListCopier.copy(outputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(OutputContext ... outputContexts) {
            this.outputContexts(Arrays.asList(outputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(Consumer<OutputContext.Builder> ... outputContexts) {
            this.outputContexts(Stream.of(outputContexts).map(c -> (OutputContext)((OutputContext.Builder)OutputContext.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public IntentSummary build() {
            return new IntentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IntentSummary> {
        public Builder intentId(String var1);

        public Builder intentName(String var1);

        public Builder description(String var1);

        public Builder parentIntentSignature(String var1);

        public Builder inputContexts(Collection<InputContext> var1);

        public Builder inputContexts(InputContext ... var1);

        public Builder inputContexts(Consumer<InputContext.Builder> ... var1);

        public Builder outputContexts(Collection<OutputContext> var1);

        public Builder outputContexts(OutputContext ... var1);

        public Builder outputContexts(Consumer<OutputContext.Builder> ... var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

