/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.TagMapCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationDataSource;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetGenerationStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetStorageLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartTestSetGenerationResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, StartTestSetGenerationResponse> {
    private static final SdkField<String> TEST_SET_GENERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSetGenerationId").getter(StartTestSetGenerationResponse.getter(StartTestSetGenerationResponse::testSetGenerationId)).setter(StartTestSetGenerationResponse.setter(Builder::testSetGenerationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetGenerationId").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(StartTestSetGenerationResponse.getter(StartTestSetGenerationResponse::creationDateTime)).setter(StartTestSetGenerationResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<String> TEST_SET_GENERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSetGenerationStatus").getter(StartTestSetGenerationResponse.getter(StartTestSetGenerationResponse::testSetGenerationStatusAsString)).setter(StartTestSetGenerationResponse.setter(Builder::testSetGenerationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetGenerationStatus").build()}).build();
    private static final SdkField<String> TEST_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSetName").getter(StartTestSetGenerationResponse.getter(StartTestSetGenerationResponse::testSetName)).setter(StartTestSetGenerationResponse.setter(Builder::testSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(StartTestSetGenerationResponse.getter(StartTestSetGenerationResponse::description)).setter(StartTestSetGenerationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<TestSetStorageLocation> STORAGE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storageLocation").getter(StartTestSetGenerationResponse.getter(StartTestSetGenerationResponse::storageLocation)).setter(StartTestSetGenerationResponse.setter(Builder::storageLocation)).constructor(TestSetStorageLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageLocation").build()}).build();
    private static final SdkField<TestSetGenerationDataSource> GENERATION_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("generationDataSource").getter(StartTestSetGenerationResponse.getter(StartTestSetGenerationResponse::generationDataSource)).setter(StartTestSetGenerationResponse.setter(Builder::generationDataSource)).constructor(TestSetGenerationDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationDataSource").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(StartTestSetGenerationResponse.getter(StartTestSetGenerationResponse::roleArn)).setter(StartTestSetGenerationResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Map<String, String>> TEST_SET_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("testSetTags").getter(StartTestSetGenerationResponse.getter(StartTestSetGenerationResponse::testSetTags)).setter(StartTestSetGenerationResponse.setter(Builder::testSetTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SET_GENERATION_ID_FIELD, CREATION_DATE_TIME_FIELD, TEST_SET_GENERATION_STATUS_FIELD, TEST_SET_NAME_FIELD, DESCRIPTION_FIELD, STORAGE_LOCATION_FIELD, GENERATION_DATA_SOURCE_FIELD, ROLE_ARN_FIELD, TEST_SET_TAGS_FIELD));
    private final String testSetGenerationId;
    private final Instant creationDateTime;
    private final String testSetGenerationStatus;
    private final String testSetName;
    private final String description;
    private final TestSetStorageLocation storageLocation;
    private final TestSetGenerationDataSource generationDataSource;
    private final String roleArn;
    private final Map<String, String> testSetTags;

    private StartTestSetGenerationResponse(BuilderImpl builder) {
        super(builder);
        this.testSetGenerationId = builder.testSetGenerationId;
        this.creationDateTime = builder.creationDateTime;
        this.testSetGenerationStatus = builder.testSetGenerationStatus;
        this.testSetName = builder.testSetName;
        this.description = builder.description;
        this.storageLocation = builder.storageLocation;
        this.generationDataSource = builder.generationDataSource;
        this.roleArn = builder.roleArn;
        this.testSetTags = builder.testSetTags;
    }

    public final String testSetGenerationId() {
        return this.testSetGenerationId;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final TestSetGenerationStatus testSetGenerationStatus() {
        return TestSetGenerationStatus.fromValue(this.testSetGenerationStatus);
    }

    public final String testSetGenerationStatusAsString() {
        return this.testSetGenerationStatus;
    }

    public final String testSetName() {
        return this.testSetName;
    }

    public final String description() {
        return this.description;
    }

    public final TestSetStorageLocation storageLocation() {
        return this.storageLocation;
    }

    public final TestSetGenerationDataSource generationDataSource() {
        return this.generationDataSource;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasTestSetTags() {
        return this.testSetTags != null && !(this.testSetTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> testSetTags() {
        return this.testSetTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetGenerationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetGenerationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.testSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestSetTags() ? this.testSetTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTestSetGenerationResponse)) {
            return false;
        }
        StartTestSetGenerationResponse other = (StartTestSetGenerationResponse)((Object)obj);
        return Objects.equals(this.testSetGenerationId(), other.testSetGenerationId()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.testSetGenerationStatusAsString(), other.testSetGenerationStatusAsString()) && Objects.equals(this.testSetName(), other.testSetName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.storageLocation(), other.storageLocation()) && Objects.equals(this.generationDataSource(), other.generationDataSource()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasTestSetTags() == other.hasTestSetTags() && Objects.equals(this.testSetTags(), other.testSetTags());
    }

    public final String toString() {
        return ToString.builder((String)"StartTestSetGenerationResponse").add("TestSetGenerationId", (Object)this.testSetGenerationId()).add("CreationDateTime", (Object)this.creationDateTime()).add("TestSetGenerationStatus", (Object)this.testSetGenerationStatusAsString()).add("TestSetName", (Object)this.testSetName()).add("Description", (Object)this.description()).add("StorageLocation", (Object)this.storageLocation()).add("GenerationDataSource", (Object)this.generationDataSource()).add("RoleArn", (Object)this.roleArn()).add("TestSetTags", this.hasTestSetTags() ? this.testSetTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testSetGenerationId": {
                return Optional.ofNullable(clazz.cast(this.testSetGenerationId()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "testSetGenerationStatus": {
                return Optional.ofNullable(clazz.cast(this.testSetGenerationStatusAsString()));
            }
            case "testSetName": {
                return Optional.ofNullable(clazz.cast(this.testSetName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "storageLocation": {
                return Optional.ofNullable(clazz.cast(this.storageLocation()));
            }
            case "generationDataSource": {
                return Optional.ofNullable(clazz.cast(this.generationDataSource()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "testSetTags": {
                return Optional.ofNullable(clazz.cast(this.testSetTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTestSetGenerationResponse, T> g) {
        return obj -> g.apply((StartTestSetGenerationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String testSetGenerationId;
        private Instant creationDateTime;
        private String testSetGenerationStatus;
        private String testSetName;
        private String description;
        private TestSetStorageLocation storageLocation;
        private TestSetGenerationDataSource generationDataSource;
        private String roleArn;
        private Map<String, String> testSetTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartTestSetGenerationResponse model) {
            super(model);
            this.testSetGenerationId(model.testSetGenerationId);
            this.creationDateTime(model.creationDateTime);
            this.testSetGenerationStatus(model.testSetGenerationStatus);
            this.testSetName(model.testSetName);
            this.description(model.description);
            this.storageLocation(model.storageLocation);
            this.generationDataSource(model.generationDataSource);
            this.roleArn(model.roleArn);
            this.testSetTags(model.testSetTags);
        }

        public final String getTestSetGenerationId() {
            return this.testSetGenerationId;
        }

        public final void setTestSetGenerationId(String testSetGenerationId) {
            this.testSetGenerationId = testSetGenerationId;
        }

        @Override
        public final Builder testSetGenerationId(String testSetGenerationId) {
            this.testSetGenerationId = testSetGenerationId;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getTestSetGenerationStatus() {
            return this.testSetGenerationStatus;
        }

        public final void setTestSetGenerationStatus(String testSetGenerationStatus) {
            this.testSetGenerationStatus = testSetGenerationStatus;
        }

        @Override
        public final Builder testSetGenerationStatus(String testSetGenerationStatus) {
            this.testSetGenerationStatus = testSetGenerationStatus;
            return this;
        }

        @Override
        public final Builder testSetGenerationStatus(TestSetGenerationStatus testSetGenerationStatus) {
            this.testSetGenerationStatus(testSetGenerationStatus == null ? null : testSetGenerationStatus.toString());
            return this;
        }

        public final String getTestSetName() {
            return this.testSetName;
        }

        public final void setTestSetName(String testSetName) {
            this.testSetName = testSetName;
        }

        @Override
        public final Builder testSetName(String testSetName) {
            this.testSetName = testSetName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final TestSetStorageLocation.Builder getStorageLocation() {
            return this.storageLocation != null ? this.storageLocation.toBuilder() : null;
        }

        public final void setStorageLocation(TestSetStorageLocation.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        @Override
        public final Builder storageLocation(TestSetStorageLocation storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        public final TestSetGenerationDataSource.Builder getGenerationDataSource() {
            return this.generationDataSource != null ? this.generationDataSource.toBuilder() : null;
        }

        public final void setGenerationDataSource(TestSetGenerationDataSource.BuilderImpl generationDataSource) {
            this.generationDataSource = generationDataSource != null ? generationDataSource.build() : null;
        }

        @Override
        public final Builder generationDataSource(TestSetGenerationDataSource generationDataSource) {
            this.generationDataSource = generationDataSource;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Map<String, String> getTestSetTags() {
            if (this.testSetTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.testSetTags;
        }

        public final void setTestSetTags(Map<String, String> testSetTags) {
            this.testSetTags = TagMapCopier.copy(testSetTags);
        }

        @Override
        public final Builder testSetTags(Map<String, String> testSetTags) {
            this.testSetTags = TagMapCopier.copy(testSetTags);
            return this;
        }

        @Override
        public StartTestSetGenerationResponse build() {
            return new StartTestSetGenerationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartTestSetGenerationResponse> {
        public Builder testSetGenerationId(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder testSetGenerationStatus(String var1);

        public Builder testSetGenerationStatus(TestSetGenerationStatus var1);

        public Builder testSetName(String var1);

        public Builder description(String var1);

        public Builder storageLocation(TestSetStorageLocation var1);

        default public Builder storageLocation(Consumer<TestSetStorageLocation.Builder> storageLocation) {
            return this.storageLocation((TestSetStorageLocation)((TestSetStorageLocation.Builder)TestSetStorageLocation.builder().applyMutation(storageLocation)).build());
        }

        public Builder generationDataSource(TestSetGenerationDataSource var1);

        default public Builder generationDataSource(Consumer<TestSetGenerationDataSource.Builder> generationDataSource) {
            return this.generationDataSource((TestSetGenerationDataSource)((TestSetGenerationDataSource.Builder)TestSetGenerationDataSource.builder().applyMutation(generationDataSource)).build());
        }

        public Builder roleArn(String var1);

        public Builder testSetTags(Map<String, String> var1);
    }
}

