/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TestSetStatus {
    IMPORTING("Importing"),
    PENDING_ANNOTATION("PendingAnnotation"),
    DELETING("Deleting"),
    VALIDATION_ERROR("ValidationError"),
    READY("Ready"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TestSetStatus> VALUE_MAP;
    private final String value;

    private TestSetStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TestSetStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TestSetStatus> knownValues() {
        EnumSet<TestSetStatus> knownValues = EnumSet.allOf(TestSetStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TestSetStatus.class, TestSetStatus::toString);
    }
}

