/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.ConversationLevelResultDetail;
import software.amazon.awssdk.services.lexmodelsv2.model.ExecutionErrorDetails;
import software.amazon.awssdk.services.lexmodelsv2.model.TestResultMatchStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.UserTurnInputSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.UserTurnOutputSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserTurnResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserTurnResult> {
    private static final SdkField<UserTurnInputSpecification> INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("input").getter(UserTurnResult.getter(UserTurnResult::input)).setter(UserTurnResult.setter(Builder::input)).constructor(UserTurnInputSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("input").build()}).build();
    private static final SdkField<UserTurnOutputSpecification> EXPECTED_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("expectedOutput").getter(UserTurnResult.getter(UserTurnResult::expectedOutput)).setter(UserTurnResult.setter(Builder::expectedOutput)).constructor(UserTurnOutputSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedOutput").build()}).build();
    private static final SdkField<UserTurnOutputSpecification> ACTUAL_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actualOutput").getter(UserTurnResult.getter(UserTurnResult::actualOutput)).setter(UserTurnResult.setter(Builder::actualOutput)).constructor(UserTurnOutputSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualOutput").build()}).build();
    private static final SdkField<ExecutionErrorDetails> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorDetails").getter(UserTurnResult.getter(UserTurnResult::errorDetails)).setter(UserTurnResult.setter(Builder::errorDetails)).constructor(ExecutionErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetails").build()}).build();
    private static final SdkField<String> END_TO_END_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endToEndResult").getter(UserTurnResult.getter(UserTurnResult::endToEndResultAsString)).setter(UserTurnResult.setter(Builder::endToEndResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endToEndResult").build()}).build();
    private static final SdkField<String> INTENT_MATCH_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("intentMatchResult").getter(UserTurnResult.getter(UserTurnResult::intentMatchResultAsString)).setter(UserTurnResult.setter(Builder::intentMatchResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentMatchResult").build()}).build();
    private static final SdkField<String> SLOT_MATCH_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("slotMatchResult").getter(UserTurnResult.getter(UserTurnResult::slotMatchResultAsString)).setter(UserTurnResult.setter(Builder::slotMatchResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotMatchResult").build()}).build();
    private static final SdkField<String> SPEECH_TRANSCRIPTION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("speechTranscriptionResult").getter(UserTurnResult.getter(UserTurnResult::speechTranscriptionResultAsString)).setter(UserTurnResult.setter(Builder::speechTranscriptionResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("speechTranscriptionResult").build()}).build();
    private static final SdkField<ConversationLevelResultDetail> CONVERSATION_LEVEL_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("conversationLevelResult").getter(UserTurnResult.getter(UserTurnResult::conversationLevelResult)).setter(UserTurnResult.setter(Builder::conversationLevelResult)).constructor(ConversationLevelResultDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationLevelResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD, EXPECTED_OUTPUT_FIELD, ACTUAL_OUTPUT_FIELD, ERROR_DETAILS_FIELD, END_TO_END_RESULT_FIELD, INTENT_MATCH_RESULT_FIELD, SLOT_MATCH_RESULT_FIELD, SPEECH_TRANSCRIPTION_RESULT_FIELD, CONVERSATION_LEVEL_RESULT_FIELD));
    private static final long serialVersionUID = 1L;
    private final UserTurnInputSpecification input;
    private final UserTurnOutputSpecification expectedOutput;
    private final UserTurnOutputSpecification actualOutput;
    private final ExecutionErrorDetails errorDetails;
    private final String endToEndResult;
    private final String intentMatchResult;
    private final String slotMatchResult;
    private final String speechTranscriptionResult;
    private final ConversationLevelResultDetail conversationLevelResult;

    private UserTurnResult(BuilderImpl builder) {
        this.input = builder.input;
        this.expectedOutput = builder.expectedOutput;
        this.actualOutput = builder.actualOutput;
        this.errorDetails = builder.errorDetails;
        this.endToEndResult = builder.endToEndResult;
        this.intentMatchResult = builder.intentMatchResult;
        this.slotMatchResult = builder.slotMatchResult;
        this.speechTranscriptionResult = builder.speechTranscriptionResult;
        this.conversationLevelResult = builder.conversationLevelResult;
    }

    public final UserTurnInputSpecification input() {
        return this.input;
    }

    public final UserTurnOutputSpecification expectedOutput() {
        return this.expectedOutput;
    }

    public final UserTurnOutputSpecification actualOutput() {
        return this.actualOutput;
    }

    public final ExecutionErrorDetails errorDetails() {
        return this.errorDetails;
    }

    public final TestResultMatchStatus endToEndResult() {
        return TestResultMatchStatus.fromValue(this.endToEndResult);
    }

    public final String endToEndResultAsString() {
        return this.endToEndResult;
    }

    public final TestResultMatchStatus intentMatchResult() {
        return TestResultMatchStatus.fromValue(this.intentMatchResult);
    }

    public final String intentMatchResultAsString() {
        return this.intentMatchResult;
    }

    public final TestResultMatchStatus slotMatchResult() {
        return TestResultMatchStatus.fromValue(this.slotMatchResult);
    }

    public final String slotMatchResultAsString() {
        return this.slotMatchResult;
    }

    public final TestResultMatchStatus speechTranscriptionResult() {
        return TestResultMatchStatus.fromValue(this.speechTranscriptionResult);
    }

    public final String speechTranscriptionResultAsString() {
        return this.speechTranscriptionResult;
    }

    public final ConversationLevelResultDetail conversationLevelResult() {
        return this.conversationLevelResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.endToEndResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.intentMatchResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slotMatchResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.speechTranscriptionResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.conversationLevelResult());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserTurnResult)) {
            return false;
        }
        UserTurnResult other = (UserTurnResult)obj;
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.expectedOutput(), other.expectedOutput()) && Objects.equals(this.actualOutput(), other.actualOutput()) && Objects.equals(this.errorDetails(), other.errorDetails()) && Objects.equals(this.endToEndResultAsString(), other.endToEndResultAsString()) && Objects.equals(this.intentMatchResultAsString(), other.intentMatchResultAsString()) && Objects.equals(this.slotMatchResultAsString(), other.slotMatchResultAsString()) && Objects.equals(this.speechTranscriptionResultAsString(), other.speechTranscriptionResultAsString()) && Objects.equals(this.conversationLevelResult(), other.conversationLevelResult());
    }

    public final String toString() {
        return ToString.builder((String)"UserTurnResult").add("Input", (Object)this.input()).add("ExpectedOutput", (Object)this.expectedOutput()).add("ActualOutput", (Object)this.actualOutput()).add("ErrorDetails", (Object)this.errorDetails()).add("EndToEndResult", (Object)this.endToEndResultAsString()).add("IntentMatchResult", (Object)this.intentMatchResultAsString()).add("SlotMatchResult", (Object)this.slotMatchResultAsString()).add("SpeechTranscriptionResult", (Object)this.speechTranscriptionResultAsString()).add("ConversationLevelResult", (Object)this.conversationLevelResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "expectedOutput": {
                return Optional.ofNullable(clazz.cast(this.expectedOutput()));
            }
            case "actualOutput": {
                return Optional.ofNullable(clazz.cast(this.actualOutput()));
            }
            case "errorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
            case "endToEndResult": {
                return Optional.ofNullable(clazz.cast(this.endToEndResultAsString()));
            }
            case "intentMatchResult": {
                return Optional.ofNullable(clazz.cast(this.intentMatchResultAsString()));
            }
            case "slotMatchResult": {
                return Optional.ofNullable(clazz.cast(this.slotMatchResultAsString()));
            }
            case "speechTranscriptionResult": {
                return Optional.ofNullable(clazz.cast(this.speechTranscriptionResultAsString()));
            }
            case "conversationLevelResult": {
                return Optional.ofNullable(clazz.cast(this.conversationLevelResult()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserTurnResult, T> g) {
        return obj -> g.apply((UserTurnResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private UserTurnInputSpecification input;
        private UserTurnOutputSpecification expectedOutput;
        private UserTurnOutputSpecification actualOutput;
        private ExecutionErrorDetails errorDetails;
        private String endToEndResult;
        private String intentMatchResult;
        private String slotMatchResult;
        private String speechTranscriptionResult;
        private ConversationLevelResultDetail conversationLevelResult;

        private BuilderImpl() {
        }

        private BuilderImpl(UserTurnResult model) {
            this.input(model.input);
            this.expectedOutput(model.expectedOutput);
            this.actualOutput(model.actualOutput);
            this.errorDetails(model.errorDetails);
            this.endToEndResult(model.endToEndResult);
            this.intentMatchResult(model.intentMatchResult);
            this.slotMatchResult(model.slotMatchResult);
            this.speechTranscriptionResult(model.speechTranscriptionResult);
            this.conversationLevelResult(model.conversationLevelResult);
        }

        public final UserTurnInputSpecification.Builder getInput() {
            return this.input != null ? this.input.toBuilder() : null;
        }

        public final void setInput(UserTurnInputSpecification.BuilderImpl input) {
            this.input = input != null ? input.build() : null;
        }

        @Override
        public final Builder input(UserTurnInputSpecification input) {
            this.input = input;
            return this;
        }

        public final UserTurnOutputSpecification.Builder getExpectedOutput() {
            return this.expectedOutput != null ? this.expectedOutput.toBuilder() : null;
        }

        public final void setExpectedOutput(UserTurnOutputSpecification.BuilderImpl expectedOutput) {
            this.expectedOutput = expectedOutput != null ? expectedOutput.build() : null;
        }

        @Override
        public final Builder expectedOutput(UserTurnOutputSpecification expectedOutput) {
            this.expectedOutput = expectedOutput;
            return this;
        }

        public final UserTurnOutputSpecification.Builder getActualOutput() {
            return this.actualOutput != null ? this.actualOutput.toBuilder() : null;
        }

        public final void setActualOutput(UserTurnOutputSpecification.BuilderImpl actualOutput) {
            this.actualOutput = actualOutput != null ? actualOutput.build() : null;
        }

        @Override
        public final Builder actualOutput(UserTurnOutputSpecification actualOutput) {
            this.actualOutput = actualOutput;
            return this;
        }

        public final ExecutionErrorDetails.Builder getErrorDetails() {
            return this.errorDetails != null ? this.errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(ExecutionErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(ExecutionErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final String getEndToEndResult() {
            return this.endToEndResult;
        }

        public final void setEndToEndResult(String endToEndResult) {
            this.endToEndResult = endToEndResult;
        }

        @Override
        public final Builder endToEndResult(String endToEndResult) {
            this.endToEndResult = endToEndResult;
            return this;
        }

        @Override
        public final Builder endToEndResult(TestResultMatchStatus endToEndResult) {
            this.endToEndResult(endToEndResult == null ? null : endToEndResult.toString());
            return this;
        }

        public final String getIntentMatchResult() {
            return this.intentMatchResult;
        }

        public final void setIntentMatchResult(String intentMatchResult) {
            this.intentMatchResult = intentMatchResult;
        }

        @Override
        public final Builder intentMatchResult(String intentMatchResult) {
            this.intentMatchResult = intentMatchResult;
            return this;
        }

        @Override
        public final Builder intentMatchResult(TestResultMatchStatus intentMatchResult) {
            this.intentMatchResult(intentMatchResult == null ? null : intentMatchResult.toString());
            return this;
        }

        public final String getSlotMatchResult() {
            return this.slotMatchResult;
        }

        public final void setSlotMatchResult(String slotMatchResult) {
            this.slotMatchResult = slotMatchResult;
        }

        @Override
        public final Builder slotMatchResult(String slotMatchResult) {
            this.slotMatchResult = slotMatchResult;
            return this;
        }

        @Override
        public final Builder slotMatchResult(TestResultMatchStatus slotMatchResult) {
            this.slotMatchResult(slotMatchResult == null ? null : slotMatchResult.toString());
            return this;
        }

        public final String getSpeechTranscriptionResult() {
            return this.speechTranscriptionResult;
        }

        public final void setSpeechTranscriptionResult(String speechTranscriptionResult) {
            this.speechTranscriptionResult = speechTranscriptionResult;
        }

        @Override
        public final Builder speechTranscriptionResult(String speechTranscriptionResult) {
            this.speechTranscriptionResult = speechTranscriptionResult;
            return this;
        }

        @Override
        public final Builder speechTranscriptionResult(TestResultMatchStatus speechTranscriptionResult) {
            this.speechTranscriptionResult(speechTranscriptionResult == null ? null : speechTranscriptionResult.toString());
            return this;
        }

        public final ConversationLevelResultDetail.Builder getConversationLevelResult() {
            return this.conversationLevelResult != null ? this.conversationLevelResult.toBuilder() : null;
        }

        public final void setConversationLevelResult(ConversationLevelResultDetail.BuilderImpl conversationLevelResult) {
            this.conversationLevelResult = conversationLevelResult != null ? conversationLevelResult.build() : null;
        }

        @Override
        public final Builder conversationLevelResult(ConversationLevelResultDetail conversationLevelResult) {
            this.conversationLevelResult = conversationLevelResult;
            return this;
        }

        public UserTurnResult build() {
            return new UserTurnResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserTurnResult> {
        public Builder input(UserTurnInputSpecification var1);

        default public Builder input(Consumer<UserTurnInputSpecification.Builder> input) {
            return this.input((UserTurnInputSpecification)((UserTurnInputSpecification.Builder)UserTurnInputSpecification.builder().applyMutation(input)).build());
        }

        public Builder expectedOutput(UserTurnOutputSpecification var1);

        default public Builder expectedOutput(Consumer<UserTurnOutputSpecification.Builder> expectedOutput) {
            return this.expectedOutput((UserTurnOutputSpecification)((UserTurnOutputSpecification.Builder)UserTurnOutputSpecification.builder().applyMutation(expectedOutput)).build());
        }

        public Builder actualOutput(UserTurnOutputSpecification var1);

        default public Builder actualOutput(Consumer<UserTurnOutputSpecification.Builder> actualOutput) {
            return this.actualOutput((UserTurnOutputSpecification)((UserTurnOutputSpecification.Builder)UserTurnOutputSpecification.builder().applyMutation(actualOutput)).build());
        }

        public Builder errorDetails(ExecutionErrorDetails var1);

        default public Builder errorDetails(Consumer<ExecutionErrorDetails.Builder> errorDetails) {
            return this.errorDetails((ExecutionErrorDetails)((ExecutionErrorDetails.Builder)ExecutionErrorDetails.builder().applyMutation(errorDetails)).build());
        }

        public Builder endToEndResult(String var1);

        public Builder endToEndResult(TestResultMatchStatus var1);

        public Builder intentMatchResult(String var1);

        public Builder intentMatchResult(TestResultMatchStatus var1);

        public Builder slotMatchResult(String var1);

        public Builder slotMatchResult(TestResultMatchStatus var1);

        public Builder speechTranscriptionResult(String var1);

        public Builder speechTranscriptionResult(TestResultMatchStatus var1);

        public Builder conversationLevelResult(ConversationLevelResultDetail var1);

        default public Builder conversationLevelResult(Consumer<ConversationLevelResultDetail.Builder> conversationLevelResult) {
            return this.conversationLevelResult((ConversationLevelResultDetail)((ConversationLevelResultDetail.Builder)ConversationLevelResultDetail.builder().applyMutation(conversationLevelResult)).build());
        }
    }
}

