/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSessionMetricsResponse;

public class ListSessionMetricsPublisher
implements SdkPublisher<ListSessionMetricsResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListSessionMetricsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSessionMetricsPublisher(LexModelsV2AsyncClient client, ListSessionMetricsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSessionMetricsPublisher(LexModelsV2AsyncClient client, ListSessionMetricsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSessionMetricsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSessionMetricsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSessionMetricsResponseFetcher
    implements AsyncPageFetcher<ListSessionMetricsResponse> {
        private ListSessionMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListSessionMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSessionMetricsResponse> nextPage(ListSessionMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListSessionMetricsPublisher.this.client.listSessionMetrics(ListSessionMetricsPublisher.this.firstRequest);
            }
            return ListSessionMetricsPublisher.this.client.listSessionMetrics((ListSessionMetricsRequest)((Object)ListSessionMetricsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

