/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsResponse;

public class ListTestExecutionsIterable
implements SdkIterable<ListTestExecutionsResponse> {
    private final LexModelsV2Client client;
    private final ListTestExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTestExecutionsIterable(LexModelsV2Client client, ListTestExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTestExecutionsResponseFetcher();
    }

    public Iterator<ListTestExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTestExecutionsResponseFetcher
    implements SyncPageFetcher<ListTestExecutionsResponse> {
        private ListTestExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTestExecutionsResponse nextPage(ListTestExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListTestExecutionsIterable.this.client.listTestExecutions(ListTestExecutionsIterable.this.firstRequest);
            }
            return ListTestExecutionsIterable.this.client.listTestExecutions((ListTestExecutionsRequest)((Object)ListTestExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

