/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListTestExecutionsResponse;

public class ListTestExecutionsPublisher
implements SdkPublisher<ListTestExecutionsResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListTestExecutionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTestExecutionsPublisher(LexModelsV2AsyncClient client, ListTestExecutionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTestExecutionsPublisher(LexModelsV2AsyncClient client, ListTestExecutionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTestExecutionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTestExecutionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTestExecutionsResponseFetcher
    implements AsyncPageFetcher<ListTestExecutionsResponse> {
        private ListTestExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTestExecutionsResponse> nextPage(ListTestExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListTestExecutionsPublisher.this.client.listTestExecutions(ListTestExecutionsPublisher.this.firstRequest);
            }
            return ListTestExecutionsPublisher.this.client.listTestExecutions((ListTestExecutionsRequest)((Object)ListTestExecutionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

