/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexruntime.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.lexruntime.auth.scheme.LexRuntimeAuthSchemeParams;
import software.amazon.awssdk.services.lexruntime.auth.scheme.LexRuntimeAuthSchemeProvider;

@SdkInternalApi
public final class DefaultLexRuntimeAuthSchemeProvider
implements LexRuntimeAuthSchemeProvider {
    private static final DefaultLexRuntimeAuthSchemeProvider DEFAULT = new DefaultLexRuntimeAuthSchemeProvider();

    private DefaultLexRuntimeAuthSchemeProvider() {
    }

    public static DefaultLexRuntimeAuthSchemeProvider create() {
        return DEFAULT;
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(LexRuntimeAuthSchemeParams params) {
        ArrayList<Object> options = new ArrayList<Object>();
        switch (params.operation()) {
            case "PostContent": {
                options.add(AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)"lex").putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)params.region().id()).putSignerProperty(AwsV4HttpSigner.PAYLOAD_SIGNING_ENABLED, (Object)false).build());
                break;
            }
            default: {
                options.add(AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)"lex").putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)params.region().id()).build());
            }
        }
        return Collections.unmodifiableList(options);
    }
}

