/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lightsail.model.Blueprint;

final class BlueprintListCopier {
    BlueprintListCopier() {
    }

    static List<Blueprint> copy(Collection<? extends Blueprint> blueprintListParam) {
        Object list;
        if (blueprintListParam == null || blueprintListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            blueprintListParam.forEach(entry -> modifiableList.add(entry));
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Blueprint> copyFromBuilder(Collection<? extends Blueprint.Builder> blueprintListParam) {
        Object list;
        if (blueprintListParam == null || blueprintListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            blueprintListParam.forEach(entry -> {
                Blueprint member = entry == null ? null : (Blueprint)entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Blueprint.Builder> copyToBuilder(Collection<? extends Blueprint> blueprintListParam) {
        Object list;
        if (blueprintListParam == null || blueprintListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            ArrayList modifiableList = new ArrayList();
            blueprintListParam.forEach(entry -> {
                Blueprint.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}

