/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceAccessProtocol {
    SSH("ssh"),
    RDP("rdp"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceAccessProtocol> VALUE_MAP;
    private final String value;

    private InstanceAccessProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceAccessProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceAccessProtocol> knownValues() {
        EnumSet<InstanceAccessProtocol> knownValues = EnumSet.allOf(InstanceAccessProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceAccessProtocol.class, InstanceAccessProtocol::toString);
    }
}

