/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PricingUnit {
    GB("GB"),
    HRS("Hrs"),
    GB_MO("GB-Mo"),
    BUNDLES("Bundles"),
    QUERIES("Queries"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PricingUnit> VALUE_MAP;
    private final String value;

    private PricingUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PricingUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PricingUnit> knownValues() {
        EnumSet<PricingUnit> knownValues = EnumSet.allOf(PricingUnit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PricingUnit.class, PricingUnit::toString);
    }
}

