/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lightsail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lightsail.model.HttpEndpoint;
import software.amazon.awssdk.services.lightsail.model.HttpProtocolIpv6;
import software.amazon.awssdk.services.lightsail.model.HttpTokens;
import software.amazon.awssdk.services.lightsail.model.LightsailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInstanceMetadataOptionsRequest
extends LightsailRequest
implements ToCopyableBuilder<Builder, UpdateInstanceMetadataOptionsRequest> {
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceName").getter(UpdateInstanceMetadataOptionsRequest.getter(UpdateInstanceMetadataOptionsRequest::instanceName)).setter(UpdateInstanceMetadataOptionsRequest.setter(Builder::instanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()}).build();
    private static final SdkField<String> HTTP_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("httpTokens").getter(UpdateInstanceMetadataOptionsRequest.getter(UpdateInstanceMetadataOptionsRequest::httpTokensAsString)).setter(UpdateInstanceMetadataOptionsRequest.setter(Builder::httpTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpTokens").build()}).build();
    private static final SdkField<String> HTTP_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("httpEndpoint").getter(UpdateInstanceMetadataOptionsRequest.getter(UpdateInstanceMetadataOptionsRequest::httpEndpointAsString)).setter(UpdateInstanceMetadataOptionsRequest.setter(Builder::httpEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpEndpoint").build()}).build();
    private static final SdkField<Integer> HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("httpPutResponseHopLimit").getter(UpdateInstanceMetadataOptionsRequest.getter(UpdateInstanceMetadataOptionsRequest::httpPutResponseHopLimit)).setter(UpdateInstanceMetadataOptionsRequest.setter(Builder::httpPutResponseHopLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpPutResponseHopLimit").build()}).build();
    private static final SdkField<String> HTTP_PROTOCOL_IPV6_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("httpProtocolIpv6").getter(UpdateInstanceMetadataOptionsRequest.getter(UpdateInstanceMetadataOptionsRequest::httpProtocolIpv6AsString)).setter(UpdateInstanceMetadataOptionsRequest.setter(Builder::httpProtocolIpv6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpProtocolIpv6").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_NAME_FIELD, HTTP_TOKENS_FIELD, HTTP_ENDPOINT_FIELD, HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD, HTTP_PROTOCOL_IPV6_FIELD));
    private final String instanceName;
    private final String httpTokens;
    private final String httpEndpoint;
    private final Integer httpPutResponseHopLimit;
    private final String httpProtocolIpv6;

    private UpdateInstanceMetadataOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.instanceName = builder.instanceName;
        this.httpTokens = builder.httpTokens;
        this.httpEndpoint = builder.httpEndpoint;
        this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
        this.httpProtocolIpv6 = builder.httpProtocolIpv6;
    }

    public final String instanceName() {
        return this.instanceName;
    }

    public final HttpTokens httpTokens() {
        return HttpTokens.fromValue(this.httpTokens);
    }

    public final String httpTokensAsString() {
        return this.httpTokens;
    }

    public final HttpEndpoint httpEndpoint() {
        return HttpEndpoint.fromValue(this.httpEndpoint);
    }

    public final String httpEndpointAsString() {
        return this.httpEndpoint;
    }

    public final Integer httpPutResponseHopLimit() {
        return this.httpPutResponseHopLimit;
    }

    public final HttpProtocolIpv6 httpProtocolIpv6() {
        return HttpProtocolIpv6.fromValue(this.httpProtocolIpv6);
    }

    public final String httpProtocolIpv6AsString() {
        return this.httpProtocolIpv6;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpTokensAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpEndpointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpPutResponseHopLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpProtocolIpv6AsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInstanceMetadataOptionsRequest)) {
            return false;
        }
        UpdateInstanceMetadataOptionsRequest other = (UpdateInstanceMetadataOptionsRequest)((Object)obj);
        return Objects.equals(this.instanceName(), other.instanceName()) && Objects.equals(this.httpTokensAsString(), other.httpTokensAsString()) && Objects.equals(this.httpEndpointAsString(), other.httpEndpointAsString()) && Objects.equals(this.httpPutResponseHopLimit(), other.httpPutResponseHopLimit()) && Objects.equals(this.httpProtocolIpv6AsString(), other.httpProtocolIpv6AsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateInstanceMetadataOptionsRequest").add("InstanceName", (Object)this.instanceName()).add("HttpTokens", (Object)this.httpTokensAsString()).add("HttpEndpoint", (Object)this.httpEndpointAsString()).add("HttpPutResponseHopLimit", (Object)this.httpPutResponseHopLimit()).add("HttpProtocolIpv6", (Object)this.httpProtocolIpv6AsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceName": {
                return Optional.ofNullable(clazz.cast(this.instanceName()));
            }
            case "httpTokens": {
                return Optional.ofNullable(clazz.cast(this.httpTokensAsString()));
            }
            case "httpEndpoint": {
                return Optional.ofNullable(clazz.cast(this.httpEndpointAsString()));
            }
            case "httpPutResponseHopLimit": {
                return Optional.ofNullable(clazz.cast(this.httpPutResponseHopLimit()));
            }
            case "httpProtocolIpv6": {
                return Optional.ofNullable(clazz.cast(this.httpProtocolIpv6AsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInstanceMetadataOptionsRequest, T> g) {
        return obj -> g.apply((UpdateInstanceMetadataOptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LightsailRequest.BuilderImpl
    implements Builder {
        private String instanceName;
        private String httpTokens;
        private String httpEndpoint;
        private Integer httpPutResponseHopLimit;
        private String httpProtocolIpv6;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInstanceMetadataOptionsRequest model) {
            super(model);
            this.instanceName(model.instanceName);
            this.httpTokens(model.httpTokens);
            this.httpEndpoint(model.httpEndpoint);
            this.httpPutResponseHopLimit(model.httpPutResponseHopLimit);
            this.httpProtocolIpv6(model.httpProtocolIpv6);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final String getHttpTokens() {
            return this.httpTokens;
        }

        public final void setHttpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
        }

        @Override
        public final Builder httpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        @Override
        public final Builder httpTokens(HttpTokens httpTokens) {
            this.httpTokens(httpTokens == null ? null : httpTokens.toString());
            return this;
        }

        public final String getHttpEndpoint() {
            return this.httpEndpoint;
        }

        public final void setHttpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
        }

        @Override
        public final Builder httpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        @Override
        public final Builder httpEndpoint(HttpEndpoint httpEndpoint) {
            this.httpEndpoint(httpEndpoint == null ? null : httpEndpoint.toString());
            return this;
        }

        public final Integer getHttpPutResponseHopLimit() {
            return this.httpPutResponseHopLimit;
        }

        public final void setHttpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
        }

        @Override
        public final Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        public final String getHttpProtocolIpv6() {
            return this.httpProtocolIpv6;
        }

        public final void setHttpProtocolIpv6(String httpProtocolIpv6) {
            this.httpProtocolIpv6 = httpProtocolIpv6;
        }

        @Override
        public final Builder httpProtocolIpv6(String httpProtocolIpv6) {
            this.httpProtocolIpv6 = httpProtocolIpv6;
            return this;
        }

        @Override
        public final Builder httpProtocolIpv6(HttpProtocolIpv6 httpProtocolIpv6) {
            this.httpProtocolIpv6(httpProtocolIpv6 == null ? null : httpProtocolIpv6.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInstanceMetadataOptionsRequest build() {
            return new UpdateInstanceMetadataOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LightsailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateInstanceMetadataOptionsRequest> {
        public Builder instanceName(String var1);

        public Builder httpTokens(String var1);

        public Builder httpTokens(HttpTokens var1);

        public Builder httpEndpoint(String var1);

        public Builder httpEndpoint(HttpEndpoint var1);

        public Builder httpPutResponseHopLimit(Integer var1);

        public Builder httpProtocolIpv6(String var1);

        public Builder httpProtocolIpv6(HttpProtocolIpv6 var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

