/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DimensionUnit {
    METERS("Meters"),
    FEET("Feet"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DimensionUnit> VALUE_MAP;
    private final String value;

    private DimensionUnit(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DimensionUnit fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DimensionUnit> knownValues() {
        EnumSet<DimensionUnit> knownValues = EnumSet.allOf(DimensionUnit.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DimensionUnit.class, DimensionUnit::toString);
    }
}

