/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.location.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.location.LocationClient;
import software.amazon.awssdk.services.location.internal.UserAgentUtils;
import software.amazon.awssdk.services.location.model.DevicePosition;
import software.amazon.awssdk.services.location.model.GetDevicePositionHistoryRequest;
import software.amazon.awssdk.services.location.model.GetDevicePositionHistoryResponse;

public class GetDevicePositionHistoryIterable
implements SdkIterable<GetDevicePositionHistoryResponse> {
    private final LocationClient client;
    private final GetDevicePositionHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetDevicePositionHistoryIterable(LocationClient client, GetDevicePositionHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetDevicePositionHistoryResponseFetcher();
    }

    public Iterator<GetDevicePositionHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DevicePosition> devicePositions() {
        Function<GetDevicePositionHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.devicePositions() != null) {
                return response.devicePositions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetDevicePositionHistoryResponseFetcher
    implements SyncPageFetcher<GetDevicePositionHistoryResponse> {
        private GetDevicePositionHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetDevicePositionHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetDevicePositionHistoryResponse nextPage(GetDevicePositionHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetDevicePositionHistoryIterable.this.client.getDevicePositionHistory(GetDevicePositionHistoryIterable.this.firstRequest);
            }
            return GetDevicePositionHistoryIterable.this.client.getDevicePositionHistory((GetDevicePositionHistoryRequest)((Object)GetDevicePositionHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

