/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentClient;
import software.amazon.awssdk.services.lookoutequipment.internal.UserAgentUtils;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsResponse;

public class ListInferenceEventsIterable
implements SdkIterable<ListInferenceEventsResponse> {
    private final LookoutEquipmentClient client;
    private final ListInferenceEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInferenceEventsIterable(LookoutEquipmentClient client, ListInferenceEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInferenceEventsResponseFetcher();
    }

    public Iterator<ListInferenceEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListInferenceEventsResponseFetcher
    implements SyncPageFetcher<ListInferenceEventsResponse> {
        private ListInferenceEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListInferenceEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInferenceEventsResponse nextPage(ListInferenceEventsResponse previousPage) {
            if (previousPage == null) {
                return ListInferenceEventsIterable.this.client.listInferenceEvents(ListInferenceEventsIterable.this.firstRequest);
            }
            return ListInferenceEventsIterable.this.client.listInferenceEvents((ListInferenceEventsRequest)((Object)ListInferenceEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

